/*
 * Copyright (C) 2000  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: rkeene@netfueldesign.com
 */


/*
	Compress by gathering bytes that are most often placed near each other
	and rearranging the ASCII Charectar Set to make those bytes have
	similar values.

*/


#include "dact.h"
#include "comp_mzlib2.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "sort.h"
#define SQRD_256 65536


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_mzlib2_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_mzlib2_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_mzlib2_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_mzlib2_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	FOUR_BYTES freq[SQRD_256];
	int i;

	memset(freq,0,sizeof(freq));

	for (i=0;i<blk_size;i++) freq[(curr_block[i]<<8)|(curr_block[i+1])]++;

	for (i=0;i<SQRD_256;i++)
		printf("%04x: 0x%02x and 0x%02x are near each other %i times\n",i,i>>8,i&0xff,freq[i]);

	int_sort_fast(freq, SQRD_256);

	for (i=0;i<(SQRD_256);i++) {
		printf("%04x: 0x%02x and 0x%02x are near each other %i times\n",i,(freq[i]>>24),(freq[i]>>16)&0xff,freq[i]&0xffff);
	}
	return(-1);
}

int comp_mzlib2_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	printf("Not yet supported.\n");
	return(0);
}
