#ifndef _DACT_H
#define _DACT_H

#include "config.h"

#define DACT_VER_MAJOR 0
#define DACT_VER_MINOR 6
#define DACT_VER_REVISION 4

#define DACT_MODE_COMPR 1
#define DACT_MODE_DECMP 2
#define DACT_MODE_STAT  3

#define DACT_OPT_FORCE	0
#define DACT_OPT_STDOUT	1
#define DACT_OPT_VERB	2
#define DACT_OPT_COMPLN	3
#define DACT_OPT_VERCHK	4
#define DACT_OPT_BINCHK	5

#define DACT_BLK_SIZE_MAX 4294967296
#define MAX_DACT_BLK_SIZE DACT_BLK_SIZE_MAX

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "getopt.h"
#endif

#ifdef HAVE_STDINT_H
#include <stdint.h>
#else
#include "stdint.h"
#endif

#ifndef HAVE_STRSEP
#include "strsep.h"
#endif

#define DACT_MAGIC_NUMBER 0x444354C3
#define DACT_MAGIC_OFFSET 0
#define DACT_MAGIC_SIZE   4
#define DACT_MAGIC_PEOF   0xFF3FDE08

struct dact_header {
	uint32_t	size;
	unsigned char	algo;
};

extern uint32_t DACT_BLK_SIZE;

#if defined(__FILE__) && defined(__LINE__) && defined(DEBUG)
#define PRINT_LINE fprintf(stderr, __FILE__ ":%07i: ", __LINE__)
#else
#define PRINT_LINE /**/
#endif

#define PERROR(error) { PRINT_LINE; perror("dact: " error); }
#define PRINTERR(error) { PRINT_LINE; fprintf(stderr, "dact: " error "\n"); }

#define SANITY(x, y...) if ((x(y))<0) { PERROR(#x); return(-1); }
#ifdef DEBUG
#define SHOWVAL(x...) fprintf(stderr, "%s=%li\n", #x, (long) (x))
#define SPOTVAR_NUM(x) fprintf(stderr, "%s=%li\n", #x, (long) x)
#define SPOTVAR_STR(x) fprintf(stderr, "%s=\"%s\"\n", #x, x)
#else
#define SHOWVAL(x...) x
#define SPOTVAR_NUM(x) /**/
#define SPOTVAR_STR(x) /**/
#endif

#ifndef DACT_FAILED_ALGO
#define DACT_FAILED_ALGO comp_fail_algo
#endif

#endif/*_DACT_H*/
