#ifndef _ALGORITHMS_H
#define _ALOGIRTHMS_H
/*
	Algorithms!
*/

#include "dact.h"
#include "comp_plain.h"
#include "comp_rle.h"
#include "comp_delta.h"
#ifdef HAVE_LIBZ
#include "comp_zlib.h"
#include "comp_mzlib.h"
#include "comp_mzlib2.h"
#endif
#ifdef HAVE_LIBBZ2
#include "comp_bzlib.h"
#endif
#ifdef DEBUG
#include "comp_factor.h"
#endif
#include "comp_range.h"
#include "comp_snibble.h"
#include "comp_text.h"
#include "comp_fail.h"
#include "comp_bitsums.h"

#ifdef __DACT_C
int (*(algorithms[256]))()={    comp_plain_algo,
                                comp_rle_algo,
                                comp_delta_algo,
				comp_text_algo,
#ifdef HAVE_LIBZ
				comp_zlib_algo,
				comp_mzlib_algo,
#else
				DACT_FAILED_ALGO,
				DACT_FAILED_ALGO,
#endif
				comp_snibble_algo,
//				comp_range_algo,
				DACT_FAILED_ALGO,
#ifdef HAVE_LIBZ
//				comp_mzlib2_algo,
				DACT_FAILED_ALGO,
#else
				DACT_FAILED_ALGO,
#endif
#ifdef HAVE_LIBBZ2
				comp_bzlib_algo,
#else
				DACT_FAILED_ALGO,
#endif
#ifdef DEBUG
				comp_factor_algo,
				comp_bitsums_algo,
#else
				DACT_FAILED_ALGO,
				DACT_FAILED_ALGO,
#endif
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL,
                                NULL};

char *algorithm_names[256]={	"Uncompressed",
				"RLE Compression",
				"Delta Compression",
				"Text Compression",
#ifdef HAVE_LIBZ
				"Zlib Compression",
				"Modified Zlib Compression",
#else
				"Unsupported Algorithm (zlib)",
				"Unsupported Algorithm (mzlib)",
#endif
				"Seminibble Encoding",
				"Range Encoding",
#ifdef HAVE_LIBZ
				"Second Modified Zlib Compression",
#else
				"Unsupported Algorithm (mzlib2)",
#endif
#ifdef HAVE_LIBBZ2
				"Bzip2 Compression",
#else
				"Unsupported Algorithm (bzlib)",
#endif
#ifdef DEBUG
				"Factor Compression",
				"Bitsums Compression",
#else
				"Unsupported Algorithm (factor)",
				"Unsupported Algorithm (bitsums)",
#endif
				NULL
			};
#else
extern int (*(algorithms[256]))();
extern char *algorithm_names[256];
#endif
#endif
