/*
 * Default DACT UI, this will probably be made modulizable.
 * 
 *   -- Roy Keene <rkeene@RKeene.org>
 *
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "dact.h"
#include "ui.h"

char dact_ui_statusvar[128];

void dact_ui_update(void) {
	static int drawing=0;
	float done;
	char *bar1, *bar2;
	int width=80,percent;

	if (!dact_ui_getopt(DACT_UI_OPT_LEVEL)) return; /* LEVEL 0 is Quiet */
	percent=dact_ui_getopt(DACT_UI_OPT_PERCENT);

	if (getenv("COLUMNS")!=NULL) width=atoi(getenv("COLUMNS"));
	if (width<10) return;
	width=(width>30?10:5);

	if (percent>100) percent=100;
	if (percent>-1) {
		done=(((float) width)*(((float) percent)/100));

		bar1=malloc((int) done+2);
		bar2=malloc((int) (width-done)+3);
		memset(bar1,'#',(int) done);
		memset(bar2,'.',(int) (width-done+0.9999999));
		bar1[(int) done]=0;
		bar2[(int) (width-done+0.9999999)]=0;
	} else {
		bar2=malloc(width+1);
		memset(bar2,'?',width);
		bar2[width]=0;
		bar1=bar2+width;
		percent=0;
	}
	if (dact_ui_getopt(DACT_UI_OPT_COLOR)) {
		fprintf(stderr, "=> \033[1;30m[\033[1;32m%s\033[1;37m%s\033[1;30m] \033[1;37m%03i\033[0;31m%%\033[0m",bar1,bar2,percent);
	} else {
		fprintf(stderr, "=> [%s%s] %03i%%",bar1,bar2,percent);
	}
	fprintf(stderr, " [%c] | Status: %s\033[K\r",*("-\\|/"+(drawing&3)),dact_ui_statusvar);
	fflush(stdout);

	free(bar2);
	if (bar1!=(bar2+width)) free(bar1);

	drawing++;
	return;
}

void dact_ui_init(void /*for now*/) {
	dact_ui_setopt(DACT_UI_OPT_COLOR, 1);
	dact_ui_status(0,"Initialized.");
}

void dact_ui_deinit(void) {
	if (dact_ui_getopt(DACT_UI_OPT_LEVEL)) fprintf(stderr, "\n");
}






void dact_ui_percentdone(int percent) {
	dact_ui_setopt(DACT_UI_OPT_PERCENT,percent);
	dact_ui_update();
}

void dact_ui_incrblkcnt(int n) {
	static uint32_t blkcnt=0;
	uint32_t blocks;

	if (n==0) blkcnt=0;

	blkcnt+=n;
	blocks=dact_ui_getopt(DACT_UI_OPT_FILEBLKS);
	if (blocks==0) { 
		dact_ui_percentdone(-1);
		return;
	}
	dact_ui_percentdone((int) ((float) (((float) blkcnt/(float) blocks)*100)));
}

int32_t dact_ui_optmanip(int action, int opt, int32_t val) {
	static int opts[4]={0,0,0,0};

	if (opt>=(sizeof(opts)/sizeof(int))) return(-1);

	switch (action) {
		case DACT_UI_MANIP_GET:
			return(opts[opt]);
			break;
		case DACT_UI_MANIP_SET:
			return(opts[opt]=val);
			break;
	}
	return(-1);
}

int32_t dact_ui_getopt(int opt) {
	return(dact_ui_optmanip(DACT_UI_MANIP_GET, opt, 0));
}

int dact_ui_setopt(int opt, int32_t val) {
	return(dact_ui_optmanip(DACT_UI_MANIP_SET, opt, val));
}

void dact_ui_status(int level, const char *status) {
	if (level>dact_ui_getopt(DACT_UI_OPT_LEVEL)) return;
	strncpy(dact_ui_statusvar,status,sizeof(dact_ui_statusvar)-1);
	dact_ui_update();
}

void dact_ui_status_append(int level, const char *status) {
	if (level>dact_ui_getopt(DACT_UI_OPT_LEVEL)) return;
	strncat(dact_ui_statusvar,status,sizeof(dact_ui_statusvar)-strlen(dact_ui_statusvar)-2);
	dact_ui_update();
}

void dact_ui_setup(uint32_t blocks) {
	dact_ui_setopt(DACT_UI_OPT_FILEBLKS,blocks);
	dact_ui_incrblkcnt(0);
}



/*
void dact_ui_debug()
void dact_ui_getuserinput()
*/
