/*
 * Copyright (C) 2001  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: dact@rkeene.org
 */

/*
	Encrypt data.
*/
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <math.h>
#include "cipher_psub.h"
#include "parse.h"
#include "dact.h"
#include "ui.h"



int cipher_psub(const unsigned char *inblock, unsigned char *outblock, const int blksize, unsigned char *key, const int mode) {
	switch (mode) {
		case (DACT_MODE_CINIT+DACT_MODE_CDEC):
		case (DACT_MODE_CINIT+DACT_MODE_CENC):
		case DACT_MODE_CINIT:
			return(cipher_psub_init(mode,key));
			break;
		case DACT_MODE_CDEC:
			return(cipher_psub_decrypt(inblock, outblock, blksize, key));
			break;
		case DACT_MODE_CENC:
			return(cipher_psub_encrypt(inblock, outblock, blksize, key));
			break;
	}
	return(0);
}


int cipher_psub_init(const int mode, unsigned char *key) {
	return(cipher_psub_init_getkey(mode-DACT_MODE_CINIT,key));
}

int cipher_psub_init_getkey(const int mode, unsigned char *key) {
	unsigned char *phrase;
	double d;
	char keybuf[1024], used[256], hbuf[4];
	int m,x,i,loc=0,num;

	phrase=dact_ui_getuserinput("Passphrase: ",128,1);

	for (i=0;i<256;i++) used[i]=0;

	if (strlen(phrase)<3) { num=257; } else { num=((259/((int) (strlen(phrase)/3)))+1); }

	for (m=0;m<strlen(phrase);m+=3) {
		memcpy(hbuf,phrase+m,3);
		hbuf[3]='\0';
		d=hash_fourbyte(hbuf, '\0');
		for (i=0;i<num;i++) {
			d=(sin(tan(d))*(255*5));
			x=((abs((int) d)&0x3ff)-255);
			if (x<0 || x>255 || used[x]) { i--; continue; }
			used[x]=1;
			if (loc==0) used[x]=0;
			keybuf[loc++]=x;
			if (loc==257) break;
		}
		if (loc==257) break;
	}
	memcpy(key,keybuf,257);
	return(257);
}

int cipher_psub_encrypt(const unsigned char *inblk, unsigned char *outblk, int blksize, unsigned char *key) {
	int i,mod;
	static int keyoffset=0;

	mod=(int) key[0];
	for (i=0;i<blksize;i++) {
		if (!(i%mod)) {
			keyoffset=((keyoffset+1)&0xff);
		}
		outblk[i]=key[((((int) inblk[i])+keyoffset)&0xff)+1];
	}
	return(blksize);
}

int cipher_psub_decrypt(const unsigned char *inblk, unsigned char *outblk, int blksize, unsigned char *key) {
	int i,mod,x;
	char reversekey[256];
	static int keyoffset=0;

	mod=(int) key[0];
	for (i=1;i<257;i++) reversekey[(int) key[i]]=(i-1);
	for (i=0;i<blksize;i++) {
		if (!(i%mod)) {
			keyoffset=((keyoffset+1)&0xff);
			for (x=0;x<256;x++) reversekey[(int) key[((x+keyoffset)&0xff)+1]]=x;
		}
		outblk[i]=reversekey[(int) inblk[i]];
	}
	return(blksize);
}
