#ifndef _DACT_H
#define _DACT_H

#include "config.h"

#ifndef DACT_CONTACT
#define DACT_CONTACT "<dact@rkeene.org>"
#endif

#ifndef DACT_KEY_SIZE
#define DACT_KEY_SIZE 2048
#endif

#define DACT_VER_MAJOR 0
#define DACT_VER_MINOR 8
#define DACT_VER_REVISION 2
#ifdef DEBUG
#define DACT_VER_SUB	"dev"
#else
#define DACT_VER_SUB	"rel"
#endif

#define DACT_MODE_COMPR 1
#define DACT_MODE_DECMP 2
#define DACT_MODE_STAT  3
#define DACT_MODE_RET   4
#define DACT_MODE_CINIT	5
#define DACT_MODE_CENC	6
#define DACT_MODE_CDEC	7
#define DACT_MODE_CIENC 11   /* CINIT+CENC */
#define DACT_MODE_DIDEC 12   /* CINIT+CDEC */

#define DACT_OPT_FORCE	0
#define DACT_OPT_STDOUT	1
#define DACT_OPT_VERB	2
#define DACT_OPT_COMPLN	3
#define DACT_OPT_VERCHK	4
#define DACT_OPT_BINCHK	5
#define DACT_OPT_TIME	6
#define DACT_OPT_PERM	7
#define DACT_OPT_ORIG	8
#define DACT_OPT_HDONLY	9
#define DACT_OPT_SZSPD	10
#define DACT_OPT_NOCRC	11
#define DACT_OPT_NETWORK	12
#define DACT_OPT_URL	13

/* These should only be changed at the risk of breaking files. 
 * (in other words, they should not be changed if possible.
 *  Adding on to them is fine.)
 */
#define DACT_HDR_CRC0	0
#define DACT_HDR_CRC1	1
#define DACT_HDR_TIME	2
#define DACT_HDR_PERM	3
#define DACT_HDR_NAME	4
#define DACT_HDR_MD5SUM	5
#define DACT_HDR_DESC	6
#define DACT_HDR_URL	7
#define DACT_HDR_URLFILE	8
#define DACT_HDR_CIPHER	9
#define DACT_HDR_NOP	10
#define DACT_HDR_IDXDATA	11

#ifndef DACT_BLK_SIZE_MAX
#define DACT_BLK_SIZE_MAX 4294967296
#define MAX_DACT_BLK_SIZE DACT_BLK_SIZE_MAX
#endif
#ifndef DACT_BLK_SIZE_DEF
#define DACT_BLK_SIZE_DEF 8192
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "getopt.h"
#endif

#ifdef HAVE_STDINT_H
#include <stdint.h>
#else
#include "stdint.h"
#endif

#ifndef HAVE_STRSEP
#include "strsep.h"
#endif

#define DACT_MAGIC_NUMBER 0x444354C3
#define DACT_MAGIC_OFFSET 0
#define DACT_MAGIC_SIZE   4
#define DACT_MAGIC_PEOF   0xFF3FDE08

struct dact_header {
	uint32_t	size;
	unsigned char	algo;
};

extern uint32_t DACT_BLK_SIZE;

#if defined(__FILE__) && defined(__LINE__) && defined(DEBUG)
#define PRINT_LINE fprintf(stderr, __FILE__ ":%07i: ", __LINE__)
#else
#define PRINT_LINE /**/
#endif

#define PERROR(error) { PRINT_LINE; perror("dact: " error); }
#define PRINTERR(error) { PRINT_LINE; fprintf(stderr, "dact: " error "\n"); }

#define SANITY(x, y...) { if ((x(y))<0) { PERROR(#x); return(-1); } }
#ifdef DEBUG
#define SHOWVAL(x...) PRINT_LINE; fprintf(stderr, "dact: %s=%li\n", #x, (long) (x))
#define SPOTVAR_NUM(x) PRINT_LINE; fprintf(stderr, "dact: %s=%li\n", #x, (long) x)
#define SPOTVAR_STR(x) PRINT_LINE; fprintf(stderr, "dact: %s=\"%s\"\n", #x, x)
#define CHECKPOINT PRINTERR("Checkpoint reached.")
#else
#define SHOWVAL(x...) x
#define SPOTVAR_NUM(x) /**/
#define SPOTVAR_STR(x) /**/
#define CHECKPOINT /**/
#endif

#ifndef DACT_FAILED_ALGO
#define DACT_FAILED_ALGO comp_fail_algo
#endif

#ifndef HAVE_SYS_SOCKET_H
#define NO_NETWORK 1
#endif

#endif/*_DACT_H*/
