AC_DEFUN(DC_ASK_STATGRAB, [
  LIBSTATGRABFLAGS=`pkg-config --libs libstatgrab 2>/dev/null`
  LIBSTATGRABCFLAGS=`pkg-config --cflags libstatgrab 2>/dev/null`
  AC_ARG_WITH(libstatgrab, [  --with-libstatgrab      Support for libstatgrab], [
# Specified
    LIBSTATGRAB=$withval
  ], [
# Not specified
    AC_CHECK_LIB(statgrab, sg_get_mem_stats, [
      OLDCPPFLAGS="$CPPFLAGS"
      OLDCFLAGS="$CFLAGS"
      CPPFLAGS="$CPPFLAGS $LIBSTATGRABCFLAGS"
      CFLAGS="$CFLAGS $LIBSTATGRABCFLAGS"
      AC_CHECK_HEADER(statgrab.h, [
        LIBSTATGRAB=yes
      ], [
        LIBSTATGRAB=no
      ])
      CPPFLAGS="$OLDCPPFLAGS"
      CFLAGS="$OLDCFLAGS"
    ], [
      LIBSTATGRAB=no
      AC_MSG_WARN(Didn't find libstatgraph)
    ], $LIBSTATGRABFLAGS)
  ])
  case $LIBSTATGRAB in
  	no)
  		AC_MSG_WARN(Freecolor will be compiled without libstatgrab support)
  		;;
  	*)
  		if test ! "${LIBSTATGRAB}" = "yes"; then
			LIBSTATGRABFLAGS="-L${LIBSTATGRAB}/lib ${LIBSTATGRABFLAGS}"
			LIBSTATGRABCFLAGS="-I${LIBSTATGRAB}/include ${LIBSTATGRABCFLAGS}"
  		fi
		AC_CHECK_LIB(statgrab, sg_get_mem_stats, [
		  OLDCFLAGS="$CFLAGS"
		  OLDCPPFLAGS="$CPPFLAGS"
		  CPPFLAGS="$CPPFLAGS ${LIBSTATGRABCFLAGS}"
		  CFLAGS="$CFLAGS ${LIBSTATGRABCFLAGS}"
  		  AC_CHECK_HEADER(statgrab.h, [
		    AC_DEFINE(HAVE_LIBSTATGRAB_H, [1], [Define to 1 if you have the <statgrab.h> header file.])
		    AC_DEFINE(HAVE_LIBSTATGRAB, [1], [Define to 1 if you have sg_get_mem_stats from -lstatgrab])
		    LIBS="$LIBS $LIBSTATGRABFLAGS"
  		    AC_CHECK_LIB(statgrab, statgrab_drop_privileges, [
		      AC_DEFINE(HAVE_STATGRAB_DROP_PRIVILEGES, [1], [Define to 1 if you have statgrab_drop_privileges from -lstatgrab])
		    ])
		  ], [
		    CFLAGS="$OLDCFLAGS"
		    CPPFLAGS="$OLDCPPFLAGS"
		    AC_MSG_ERROR(Could not find statgrab.h)
		  ])
		], [
		  AC_MSG_ERROR(Could not find libstatgrab)
		], $LIBSTATGRABFLAGS)
  		;;
  esac
])
