#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#define GP2P_VERSION PACKAGE_VERSION

#define GAIM_PLUGINS
#include <gaim.h>

#include <version.h>
#include <signals.h>

#include <gtk/gtk.h>
#include <gtkgaim.h>
#include <util.h>
#include <gtkplugin.h>
#include <gtkutils.h>

#include <string.h>
#include <ctype.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#define GP2P_PLUGIN_ID "gp2p"
#define GP2P_WEBSITE "http://www.rkeene.org/oss/gp2p/"

#define TYPE_CMD 275268
#define TYPE_RET 340308

static int gp2p_loaded = 0;

static uint32_t valhash(const char *val) {
	uint32_t ret = 0;
	const char *tmp = NULL;

	for (tmp = val; *tmp != '\0'; tmp++) {
		ret <<= 6;
		ret |= toupper(*tmp);
	}

	return(ret);
}

static char *gp2p_handle_cmd(const char *cmd, const char *data) {
	uint32_t cmdid = 0;

	cmdid = valhash(cmd);

	printf("P2P: Executing command: %s (0x%x) with parms: %s\n", cmd, cmdid, data);

	switch (cmdid) {
		default:
	}

	return(NULL);
}

static gboolean gp2p_mesg_in(GaimAccount *account, char **sender, char **buffer, int *flags, void *data) {
	uint32_t typeid = 0;
	uint16_t ttl = 0;
	size_t tmplen = 0;
	char *src = NULL, *message = NULL, *messagedata = NULL, *highptr = NULL;
	char type[128] = {0}, cmd[128] = {0}, retbuf[8192] = {0};
	char *tmp = NULL;
	char *cmdret = NULL;

	src = *sender;
	message = *buffer;

//	printf("Check Message from %s: %s\n", src, message);

	/* Ensure that we have some valid data. */
	if (message == NULL || src == NULL) {
		return(FALSE);
	}

	/* We only handle our type of messages. */
	if (strncmp("[P2P ", message, 5) != 0) {
		return(FALSE);
	}
	tmp = strstr(message, "[/P2P]");
	if (tmp == NULL) {
		return(FALSE);
	}
	*tmp = '\0';

	/* Locate the TYPE parameter. */
	tmp = strstr(message, "type=");
	if (tmp == NULL) {
		/* We return true, since we did handle the data. */
		return(TRUE);
	}
	tmp = tmp + 5; /* Skip past the `type=' part. */

	/* Ignore quotes. */
	if (*tmp == '\"') {
		tmp++;
	}

	tmplen = strcspn(tmp, "\t\n\" ]>");
	if (tmplen >= sizeof(type)) {
		tmplen = sizeof(type) - 1;
	}
	strncpy(type, tmp, tmplen);
	highptr = tmp + tmplen;

	/* Locate the TTL parameter. */
	tmp = strstr(message, "ttl=");
	if (tmp == NULL) {
		/* We return true, since we did handle the data. */
		return(TRUE);
	}
	tmp = tmp + 4; /* Skip past the `ttl=' part. */

	/* Ignore quotes. */
	if (*tmp == '\"') {
		tmp++;
	}

	tmplen = strcspn(tmp, "\t\n\" ]>");
	if (tmplen >= sizeof(type)) {
		tmplen = sizeof(type) - 1;
	}

	ttl = atoi(tmp);

	tmp = tmp + tmplen;
	if (tmp > highptr) {
		highptr = tmp;
	}

	if (ttl > 255 || ttl == 0) {
		/* We return true, since we did handle the data. */
		return(TRUE);
	}

	ttl--;

	/* Locate the COMMAND parameter, if specified. */
	tmp = strstr(message, "cmd=");
	if (tmp != NULL) {
		tmp = tmp + 4; /* Skip past the `cmd=' part. */
		/* Ignore quotes. */
		if (*tmp == '\"') {
			tmp++;
		}

		tmplen = strcspn(tmp, "\t\n\" ]>");
		if (tmplen >= sizeof(cmd)) {
			tmplen = sizeof(cmd) - 1;
		}
		strncpy(cmd, tmp, tmplen);

		tmp = tmp + tmplen;
		if (tmp > highptr) {
			highptr = tmp;
		}
	}

	messagedata = strchr(highptr, ']');
	if (messagedata == NULL) {
		return(FALSE);
	}

	messagedata++;

	typeid = valhash(type);
	switch (typeid) {
		case TYPE_CMD:
			cmdret = gp2p_handle_cmd(cmd, messagedata);
			if (cmdret != NULL) {
				snprintf(retbuf, sizeof(retbuf), "[P2P type=ret cmd=%s]%s[/P2P]", cmd, cmdret);
			}
			break;
		case TYPE_RET:
		default:
			printf("P2P Message from %s (type=%s, 0x%x; cmd=%s): %s\n", src, type, typeid, cmd, messagedata);
	}

	return(TRUE);
}

static gboolean plugin_load(GaimPlugin *plugin) {
	void *conv_handle = NULL;

	if (gp2p_loaded == 1) {
		return(TRUE);
	}

	gp2p_loaded = 1;

	conv_handle = gaim_conversations_get_handle();

        gaim_signal_connect(conv_handle, "receiving-im-msg", plugin, GAIM_CALLBACK(gp2p_mesg_in), NULL);

	return(TRUE);
}

static gboolean plugin_unload(GaimPlugin *plugin) {
	void *conv_handle = NULL;

	if (gp2p_loaded == 0) {
		return(TRUE);
	}

	conv_handle = gaim_conversations_get_handle();

	gaim_signals_disconnect_by_handle(conv_handle);

	gp2p_loaded = 0;

	return(TRUE);
}

static void gui_save(void) {
	printf("save!\n");
	return;
}

static GtkWidget *get_config_frame(GaimPlugin *plugin) {
        GtkWidget *ret = NULL;
        GtkWidget *button = NULL;

	/* Container. */
        ret = gtk_vbox_new(FALSE, 18);
	if (ret == NULL) {
		return(NULL);
	}

	gtk_container_set_border_width(GTK_CONTAINER (ret), 12);

	/* Save button */
        button = gtk_button_new_from_stock(GTK_STOCK_SAVE);
	if (button == NULL) {
		return(NULL);
	}
        g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(gui_save), NULL);
       	gtk_widget_set_sensitive(button, TRUE);
	gtk_box_pack_start(GTK_BOX(ret), button, FALSE, FALSE, 0);
        gtk_widget_show(button);

        gtk_widget_show_all(ret);
        return(ret);
}


/* Register components with gAIM: */
static GaimGtkPluginUiInfo ui_info = {
	get_config_frame
};

static GaimPluginInfo info = {
	GAIM_PLUGIN_MAGIC,
	GAIM_MAJOR_VERSION,
	GAIM_MINOR_VERSION,
	GAIM_PLUGIN_STANDARD,	                            /**< type           */
	GAIM_GTK_PLUGIN_TYPE,	                            /**< ui_requirement */
	0,	                                            /**< flags          */
	NULL,	                                            /**< dependencies   */
	GAIM_PRIORITY_DEFAULT,	                            /**< priority       */
	GP2P_PLUGIN_ID,	                                    /**< id             */
	("gAIM Peer-to-Peer"),	                    /**< name           */
	GP2P_VERSION,	                                    /**< version        */
	("File-sharing module."),                         /**  summary        */
	("gAIM Peer-to-Peer file sharing allows you to share files amongst your friends."),  /**  description    */
	"Roy Keene <gp2p@rkeene.org>",	                    /**< author         */
	GP2P_WEBSITE,	                                    /**< homepage       */
	plugin_load,	                                    /**< load           */
	plugin_unload,	                                    /**< unload         */
	NULL,	                                            /**< destroy        */
	&ui_info,	                                    /**< ui_info        */
	NULL,	                                            /**< extra_info     */
	NULL,
	NULL
};

static void init_plugin(GaimPlugin *plugin) {
	return;
}

GAIM_INIT_PLUGIN(gp2p, init_plugin, info)
