#include "compat.h"
#define GP2P_VERSION PACKAGE_VERSION

#define GAIM_PLUGINS
#include <gaim.h>

#include <version.h>
#include <signals.h>

#include <gtk/gtk.h>
#include <gtkgaim.h>
#include <util.h>
#include <gtkplugin.h>
#include <gtkutils.h>

#include "friendly.h"

#define GP2P_PLUGIN_ID "gp2p"
#define GP2P_WEBSITE "http://www.rkeene.org/oss/gp2p/"

static int gp2p_loaded = 0;

static gboolean gp2p_mesg_in(GaimAccount *account, char **sender, char **buffer, int *flags, void *data) {
	int gp_ret = 0;

	gp_ret = friendly_handle_mesg(*sender, *buffer);

	if (gp_ret) {
		return(TRUE);
	}

	return(FALSE);
}

static gboolean plugin_load(GaimPlugin *plugin) {
	void *conv_handle = NULL;

	if (gp2p_loaded == 1) {
		return(TRUE);
	}

	gp2p_loaded = 1;

	conv_handle = gaim_conversations_get_handle();

        gaim_signal_connect(conv_handle, "receiving-im-msg", plugin, GAIM_CALLBACK(gp2p_mesg_in), NULL);

	return(TRUE);
}

static gboolean plugin_unload(GaimPlugin *plugin) {
	void *conv_handle = NULL;

	if (gp2p_loaded == 0) {
		return(TRUE);
	}

	conv_handle = gaim_conversations_get_handle();

	gaim_signals_disconnect_by_handle(conv_handle);

	gp2p_loaded = 0;

	return(TRUE);
}

static void gui_save(void) {
	printf("save!\n");
	return;
}

static GtkWidget *get_config_frame(GaimPlugin *plugin) {
        GtkWidget *ret = NULL;
        GtkWidget *button = NULL;

	/* Container. */
        ret = gtk_vbox_new(FALSE, 18);
	if (ret == NULL) {
		return(NULL);
	}

	gtk_container_set_border_width(GTK_CONTAINER (ret), 12);

	/* Save button */
        button = gtk_button_new_from_stock(GTK_STOCK_SAVE);
	if (button == NULL) {
		return(NULL);
	}
        g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(gui_save), NULL);
       	gtk_widget_set_sensitive(button, TRUE);
	gtk_box_pack_start(GTK_BOX(ret), button, FALSE, FALSE, 0);
        gtk_widget_show(button);

        gtk_widget_show_all(ret);
        return(ret);
}


/* Register components with gAIM: */
static GaimGtkPluginUiInfo ui_info = {
	get_config_frame
};

static GaimPluginInfo info = {
	GAIM_PLUGIN_MAGIC,
	GAIM_MAJOR_VERSION,
	GAIM_MINOR_VERSION,
	GAIM_PLUGIN_STANDARD,	                            /**< type           */
	GAIM_GTK_PLUGIN_TYPE,	                            /**< ui_requirement */
	0,	                                            /**< flags          */
	NULL,	                                            /**< dependencies   */
	GAIM_PRIORITY_DEFAULT,	                            /**< priority       */
	GP2P_PLUGIN_ID,	                                    /**< id             */
	("gAIM Peer-to-Peer"),	                    /**< name           */
	GP2P_VERSION,	                                    /**< version        */
	("File-sharing module."),                         /**  summary        */
	("gAIM Peer-to-Peer file sharing allows you to share files amongst your friends."),  /**  description    */
	"Roy Keene <gp2p@rkeene.org>",	                    /**< author         */
	GP2P_WEBSITE,	                                    /**< homepage       */
	plugin_load,	                                    /**< load           */
	plugin_unload,	                                    /**< unload         */
	NULL,	                                            /**< destroy        */
	&ui_info,	                                    /**< ui_info        */
	NULL,	                                            /**< extra_info     */
	NULL,
	NULL
};

static void init_plugin(GaimPlugin *plugin) {
	return;
}

GAIM_INIT_PLUGIN(gp2p, init_plugin, info)
