Summary: HTTP based time synchronization tool
Name: htp
Version: 0.4.10
Release: 1
License: GNU General Public License version 2
Group: System Environment/Daemons
URL: http://www.rkeene.org/oss/htp/
Packager: Roy Keene <htp@rkeene.org>
Source: http://www.rkeene.org/files/oss/htp/htp-0.4.10.tar.gz
BuildRoot: %{_tmppath}/htp-0.4.10-root

Prereq: libconfig

%description
The HTTP Time Protocol (HTP) is used to synchronize a computer's time with web
servers as reference time source.  The HTP package contains utilities and
daemons to synchronize your computer's time using HTTP/1.1 (RFC 2616) headers
from web servers.  The HTP package includes "htpdate" (a program for
retrieving the date and time from remote machines via a network) and htpd (a
daemon which continuously adjusts the system time). HTP works through proxy
servers.  Accuracy of "htpd" will usually be within 0.5 seconds provided that
enough servers are specified. If that is not good enough for you, try the ntpd
package.

Install the htp package if you need tools for keeping your system's
time synchronized with minimal configuration and do not need millsecond
accuracy.

%prep
%setup -q

%build
./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var
make

%install
mkdir -p %{buildroot}/etc/init.d
mkdir -p %{buildroot}/usr/bin
mkdir -p %{buildroot}/usr/man/{man5,man8}

install -m 755 htpd %{buildroot}/usr/bin/htpd
install -m 755 htpdate %{buildroot}/usr/bin/htpdate
install -m 644 htpd.conf.5 %{buildroot}/usr/man/man5/htpd.conf.5
install -m 644 htpd.8 %{buildroot}/usr/man/man8/htpd.8
install -m 644 htpdate.8 %{buildroot}/usr/man/man8/htpdate.8

install -m 644 htpd.conf %{buildroot}/etc/htpd.conf
install -m 755 htpd.init %{buildroot}/etc/init.d/htpd

%clean
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}

%files
%defattr(-,root,root)
%doc README
%config /etc/init.d/htpd
%config(noreplace) /etc/htpd.conf
/usr/bin/htpd
/usr/bin/htpdate
/usr/man/man5/htpd.conf.5.gz
/usr/man/man8/htpd.8.gz
/usr/man/man8/htpdate.8.gz
