	"#! /usr/bin/env tclsh\n"
	"# ReadKit, a viewer/extractor/converter for starkits which does not\n"
	"# require TclKit or MetaKit.  This file was generated by \"rkgen.tcl\".\n"
	"#\n"
	"# June 2002, Jean-Claude Wippler <jcw@equi4.com>\n"
	"\n"
	"# this is needed so often that I just drop copies of it all over the place\n"
	"if {![info exists auto_index(lassign)] && [info commands lassign] == \"\"} {\n"
	"  proc lassign {l args} {\n"
	"    foreach v $l a $args { uplevel 1 [list set $a $v] }\n"
	"  }\n"
	"}\n"
	"\n"
	"catch {\n"
	"	load {} zlib\n"
	"}\n"
	"catch {\n"
	"	package require zlib\n"
	"}\n"
	"\n"
	"if {[info comm mmap] == \"\"} {\n"
	"    # mmap and mvec primitives in pure Tcl (a C version is present in critlib)\n"
	"\n"
	"    namespace export mmap mvec\n"
	"\n"
	"    namespace eval v {\n"
	"	array set mmap_data {}\n"
	"	array set mvec_shifts {\n"
	"    - -1    0 -1\n"
	"    1  0    2  1    4  2    8   3\n"
	"    16 4   16r 4\n"
	"    32 5   32r 5   32f 5   32fr 5\n"
	"    64 6   64r 6   64f 6   64fr 6 }\n"
	"    }\n"
	"\n"
	"    proc mmap {fd args} {\n"
	"	upvar #0 v::mmap_data($fd) data\n"
	"	# special case if fd is the name of a variable (qualified or global)\n"
	"	if {[uplevel #0 [list info exists $fd]]} {\n"
	"	    upvar #0 $fd var\n"
	"	    set data $var\n"
	"	}\n"
	"	# cache a full copy of the file to simulate memory mapping\n"
	"	if {![info exists data]} {\n"
	"	    set pos [tell $fd]\n"
	"	    seek $fd 0 end\n"
	"	    set end [tell $fd]\n"
	"	    seek $fd 0\n"
	"	    set trans [fconfigure $fd -translation]\n"
	"	    fconfigure $fd -translation binary\n"
	"	    set data [read $fd $end]\n"
	"	    fconfigure $fd -translation $trans\n"
	"	    seek $fd $pos\n"
	"	}\n"
	"	set total [string length $data]\n"
	"	if {[llength $args] == 0} {\n"
	"	    return $total\n"
	"	}\n"
	"	foreach {off len} $args break\n"
	"	if {$len < 0} {\n"
	"	    set len $total\n"
	"	}\n"
	"	if {$len < 0 || $len > $total - $off} {\n"
	"	    set len [expr {$total - $off}]\n"
	"	}\n"
	"	binary scan $data @${off}a$len s\n"
	"	return $s\n"
	"    }\n"
	"\n"
	"    proc mvec {v args} {\n"
	"	foreach {mode data off len} $v break\n"
	"	if {[info exists v::mvec_shifts($mode)]} {\n"
	"	    # use _mvec_get to access elements\n"
	"	    set shift $v::mvec_shifts($mode)\n"
	"	    if {[llength $v] < 4} {\n"
	"		set len $off\n"
	"	    }\n"
	"	    set get [list _mvec_get $shift $v *]\n"
	"	} else {\n"
	"	    # virtual mode, set to evaluate script\n"
	"	    set shift \"\"\n"
	"	    set len [lindex $v end]\n"
	"	    set get $v\n"
	"	}\n"
	"	# try to derive vector length from data length if not specified\n"
	"	if {$len == \"\" || $len < 0} {\n"
	"	    set len 0\n"
	"	    if {$shift >= 0} {\n"
	"		if {[llength $v] < 4} {\n"
	"		    set n [string length $data]\n"
	"		} else {\n"
	"		    set n [mmap $data]\n"
	"		}\n"
	"		set len [expr {($n << 3) >> $shift}]\n"
	"	    }\n"
	"	}\n"
	"	set nargs [llength $args]\n"
	"	# with just a varname as arg, return info about this vector\n"
	"	if {$nargs == 0} {\n"
	"	    if {$shift == \"\"} {\n"
	"		return [list $len {} $v]\n"
	"	    }\n"
	"	    return [list $len $mode $shift]\n"
	"	}\n"
	"	foreach {pos count pred cond} $args break\n"
	"	# with an index as second arg, do a single access and return element\n"
	"	if {$nargs == 1} {\n"
	"	    return [uplevel 1 [lreplace $get end end $pos]]\n"
	"	}\n"
	"	if {$count < 0} {\n"
	"	    set count $len\n"
	"	}\n"
	"	if {$count > $len - $pos && $shift != -1} {\n"
	"	    set count [expr {$len - $pos}]\n"
	"	}\n"
	"	if {$nargs == 4} {\n"
	"	    upvar $pred x\n"
	"	}\n"
	"	set r {}\n"
	"	incr count $pos\n"
	"	# loop through specified range to build result vector\n"
	"	# with four args, used that as predicate function to filter\n"
	"	# with five args, use fourth as loop var and apply fifth as condition\n"
	"	for {set x $pos} {$x < $count} {incr x} {\n"
	"	    set y [uplevel 1 [lreplace $get end end $x]]\n"
	"	    switch $nargs {\n"
	"		3 {\n"
	"			if {![uplevel 1 [list $pred $v $x $y]]} continue\n"
	"		    }\n"
	"		4 {\n"
	"			if {![uplevel 1 [list expr $cond]]} continue\n"
	"		    }\n"
	"	    }\n"
	"	    lappend r $y\n"
	"	}\n"
	"	return $r\n"
	"    }\n"
	"\n"
	"    proc _mvec_get {shift desc index} {\n"
	"	foreach {mode data off len} $desc break\n"
	"	switch -- $mode {\n"
	"	    - {\n"
	"		    return $index\n"
	"		}\n"
	"	    0 {\n"
	"		    return $data\n"
	"		}\n"
	"	}\n"
	"	if {[llength $desc] < 4} {\n"
	"	    set off [expr {($index << $shift) >> 3}]\n"
	"	} else {\n"
	"	    # don't load more than 8 bytes from the proper offset\n"
	"	    incr off [expr {($index << $shift) >> 3}]\n"
	"	    set data [mmap $data $off 8]\n"
	"	    set off 0\n"
	"	}\n"
	"	switch -- $mode {\n"
	"	    1 {\n"
	"		    binary scan $data @${off}c value\n"
	"		    return [expr {($value>>($index&7)) &1}]\n"
	"		}\n"
	"	    2 {\n"
	"		    binary scan $data @${off}c value\n"
	"		    return [expr {($value>>(($index&3) <<1)) &3}]\n"
	"		}\n"
	"	    4 {\n"
	"		    binary scan $data @${off}c value\n"
	"		    return [expr {($value>>(($index&1) <<2)) &15}]\n"
	"		}\n"
	"	    8 {\n"
	"		    set w 1\n"
	"		    set f c\n"
	"		}\n"
	"	    16 {\n"
	"		    set w 2\n"
	"		    set f s\n"
	"		}\n"
	"	    16r {\n"
	"		    set w 2\n"
	"		    set f S\n"
	"		}\n"
	"	    32 {\n"
	"		    set w 4\n"
	"		    set f i\n"
	"		}\n"
	"	    32r {\n"
	"		    set w 4\n"
	"		    set f I\n"
	"		}\n"
	"	    32fr -\n"
	"	    32f {\n"
	"		    set w 4\n"
	"		    set f f\n"
	"		}\n"
	"	    64 -\n"
	"	    64r {\n"
	"		    set w 8\n"
	"		    set f i2\n"
	"		}\n"
	"	    64fr -\n"
	"	    64f {\n"
	"		    set w 8\n"
	"		    set f d\n"
	"		}\n"
	"	}\n"
	"\n"
	"	binary scan $data @$off$f value\n"
	"	return $value\n"
	"    }\n"
	"\n"
	"    # vim: ft=tcl\n"
	"\n"
	"}\n"
	"\n"
	"if {[info comm dbopen] == \"\"} {\n"
	"    # Decoder for MetaKit datafiles in Tcl\n"
	"\n"
	"    # requires mmap/mvec primitives:\n"
	"    #source [file join [info dirname [info script]] mvprim.tcl]\n"
	"\n"
	"    namespace export dbopen dbclose dbtree access vnames vlen\n"
	"\n"
	"    namespace eval v {\n"
	"	variable widths {\n"
	"    {8 16  1 32  2  4}\n"
	"    {4  8  1 16  2  0}\n"
	"    {2  4  8  1  0 16}\n"
	"    {2  4  0  8  1  0}\n"
	"    {1  2  4  0  8  0}\n"
	"    {1  2  4  0  0  8}\n"
	"    {1  2  0  4  0  0} }\n"
	"    }\n"
	"\n"
	"    proc fetch {file} {\n"
	"	if {$file == \"\"} {\n"
	"	    error \"temp storages not supported\"\n"
	"	}\n"
	"	set v::data [open $file]\n"
	"	set v::seqn 0\n"
	"    }\n"
	"\n"
	"    proc byte_seg {off len} {\n"
	"	incr off $v::zero\n"
	"	return [mmap $v::data $off $len]\n"
	"    }\n"
	"\n"
	"    proc int_seg {off cnt} {\n"
	"	set vec [list 32r [byte_seg $off [expr {4*$cnt}]]]\n"
	"	return [mvec $vec 0 $cnt]\n"
	"    }\n"
	"\n"
	"    proc get_s {len} {\n"
	"	set s [byte_seg $v::curr $len]\n"
	"	incr v::curr $len\n"
	"	return $s\n"
	"    }\n"
	"\n"
	"    proc get_v {} {\n"
	"	set v 0\n"
	"	while 1 {\n"
	"	    set char [mvec $v::byte $v::curr]\n"
	"	    incr v::curr\n"
	"	    set v [expr {$v*128+($char&0xff)}]\n"
	"	    if {$char < 0} {\n"
	"		return [incr v -128]\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc get_p {rows vs vo} {\n"
	"	upvar $vs size $vo off\n"
	"	set off 0\n"
	"	if {$rows == 0} {\n"
	"	    set size 0\n"
	"	} else {\n"
	"	    set size [get_v]\n"
	"	    if {$size > 0} {\n"
	"		set off [get_v]\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc header {{end \"\"}} {\n"
	"	set v::zero 0\n"
	"	if {$end == \"\"} {\n"
	"	    set end [mmap $v::data]\n"
	"	}\n"
	"	set v::byte [list 8 $v::data $v::zero $end]\n"
	"	lassign [int_seg [expr {$end-16}] 4] t1 t2 t3 t4\n"
	"	set v::zero [expr {$end-$t2-16}]\n"
	"	incr end -$v::zero\n"
	"	set v::byte [list 8 $v::data $v::zero $end]\n"
	"	lassign [int_seg 0 2] h1 h2\n"
	"	lassign [int_seg [expr {$h2-8}] 2] e1 e2\n"
	"	set v::info(mkend) $h2\n"
	"	set v::info(mktoc) $e2\n"
	"	set v::info(mklen) [expr {$e1 & 0xffffff}]\n"
	"	set v::curr $e2\n"
	"    }\n"
	"\n"
	"    proc layout {fmt} {\n"
	"	regsub -all { } $fmt \"\" fmt\n"
	"	regsub -all {(\\w+)\\[} $fmt \"{\\\\1 {\" fmt\n"
	"	regsub -all {\\]} $fmt \"}}\" fmt\n"
	"	regsub -all {,} $fmt \" \" fmt\n"
	"	return $fmt\n"
	"    }\n"
	"\n"
	"    proc descparse {desc} {\n"
	"	set names {}\n"
	"	set types {}\n"
	"	foreach x $desc {\n"
	"	    if {[llength $x] == 1} {\n"
	"		lassign [split $x :] name type\n"
	"		if {$type == \"\"} {\n"
	"		    set type S\n"
	"		}\n"
	"	    } else {\n"
	"		lassign $x name type\n"
	"	    }\n"
	"	    lappend names $name\n"
	"	    lappend types $type\n"
	"	}\n"
	"	return [list $names $types]\n"
	"    }\n"
	"\n"
	"    proc numvec {rows type} {\n"
	"	get_p $rows size off\n"
	"	if {$size == 0} {\n"
	"	    return {0 0}\n"
	"	}\n"
	"	set w [expr {int(($size<<3) /$rows)}]\n"
	"	if {$rows <= 7 && 0 < $size && $size <= 6} {\n"
	"	    set w [lindex [lindex $v::widths [expr {$rows-1}]] [expr {$size-1}]]\n"
	"	}\n"
	"	if {$w == 0} {\n"
	"	    error \"numvec?\"\n"
	"	}\n"
	"	switch $type\\\n"
	"	      F {\n"
	"		    set w 32f\n"
	"		}\\\n"
	"	      D {\n"
	"		    set w 64f\n"
	"		}\n"
	"	incr off $v::zero\n"
	"	return [list $w $v::data $off $rows]\n"
	"    }\n"
	"\n"
	"    proc lazy_str {self rows type pos sizes msize moff index} {\n"
	"	set soff {}\n"
	"	for {set i 0} {$i < $rows} {incr i} {\n"
	"	    set n [mvec $sizes $i]\n"
	"	    lappend soff $pos\n"
	"	    incr pos $n\n"
	"	}\n"
	"	if {$msize > 0} {\n"
	"	    set slen [mvec $sizes 0 $rows]\n"
	"	    set v::curr $moff\n"
	"	    set limit [expr {$moff+$msize}]\n"
	"	    for {set row 0} {$v::curr < $limit} {incr row} {\n"
	"		incr row [get_v]\n"
	"		get_p 1 ms mo\n"
	"		set soff [lreplace $soff $row $row $mo]\n"
	"		set slen [lreplace $slen $row $row $ms]\n"
	"	    }\n"
	"	    set sizes [list lindex $slen $rows]\n"
	"	}\n"
	"	if {$type == \"S\"} {\n"
	"	    set adj -1\n"
	"	} else {\n"
	"	    set adj 0\n"
	"	}\n"
	"	set v::node($self) [list get_str $soff $sizes $adj $rows]\n"
	"	return [mvec $v::node($self) $index]\n"
	"    }\n"
	"\n"
	"    proc get_str {soff sizes adj index} {\n"
	"	set n [mvec $sizes $index]\n"
	"	return [byte_seg [lindex $soff $index] [incr n $adj]]\n"
	"    }\n"
	"\n"
	"    proc lazy_sub {self desc size off rows index} {\n"
	"	set v::curr $off\n"
	"	lassign [descparse $desc] names types\n"
	"	set subs {}\n"
	"	for {set i 0} {$i < $rows} {incr i} {\n"
	"	    if {[get_v] != 0} {\n"
	"		error \"lazy_sub?\"\n"
	"	    }\n"
	"	    lappend subs [prepare $types]\n"
	"	}\n"
	"	set v::node($self) [list get_sub $names $subs $rows]\n"
	"	return [mvec $v::node($self) $index]\n"
	"    }\n"
	"\n"
	"#proc backtrace {{level_adj 0}} {\n"
	"#                        set ret [list]          \n"
	"#\n"
	"#                        set level [expr 0 - $level_adj]\n"
	"#                        for {set i [expr [info level] - $level_adj]} {$i > 1} {incr i -1} {\n"
	"#                                incr level -1\n"
	"#                                set ret [linsert $ret 0 [lindex [info level $level] 0]]\n"
	"#                        }\n"
	"#                        set ret [linsert $ret 0 GLOBAL]\n"
	"#        \n"
	"#                        return $ret\n"
	"#}\n"
	"\n"
	"    proc get_sub {names subs index} {\n"
	"#puts stderr \"DEBUG: get_sub: [list $names $subs $index]\"\n"
	"#puts \"backtrace: [backtrace]\"\n"
	"	lassign [lindex $subs $index] rows handlers\n"
	"	return [list get_view $names $rows $handlers $rows]\n"
	"    }\n"
	"\n"
	"    proc prepare {types} {\n"
	"	set r [get_v]\n"
	"	set handlers {}\n"
	"	foreach x $types {\n"
	"	    set n [incr v::seqn]\n"
	"	    lappend handlers $n\n"
	"	    switch $x {\n"
	"		I -\n"
	"		L -\n"
	"		F -\n"
	"		D {\n"
	"			set v::node($n) [numvec $r $x]\n"
	"		    }\n"
	"		B -\n"
	"		S {\n"
	"			get_p $r size off\n"
	"			set sizes {0 0}\n"
	"			if {$size > 0} {\n"
	"			    set sizes [numvec $r I]\n"
	"			}\n"
	"			get_p $r msize moff\n"
	"			set v::node($n) [list lazy_str $n $r $x $off $sizes\\\n"
	"			  $msize $moff $r]\n"
	"		    }\n"
	"		default {\n"
	"			get_p $r size off\n"
	"			set v::node($n) [list lazy_sub $n $x $size $off $r $r]\n"
	"		    }\n"
	"	    }\n"
	"	}\n"
	"	return [list $r $handlers]\n"
	"    }\n"
	"\n"
	"    proc get_view {names rows handlers index} {\n"
	"	return [list get_prop $names $rows $handlers $index [llength $names]]\n"
	"    }\n"
	"\n"
	"    proc get_prop {names rows handlers index ident} {\n"
	"	set col [lsearch -exact $names $ident]\n"
	"	if {$col < 0} {\n"
	"	    error \"unknown property: $ident\"\n"
	"	}\n"
	"	set h [lindex $handlers $col]\n"
	"	set ret [mvec $v::node($h) $index]\n"
	"\n"
	"	return $ret\n"
	"    }\n"
	"\n"
	"    proc dbopen {db file} {\n"
	"	# open datafile, stores datafile descriptors and starts building tree\n"
	"	if {$db == \"\"} {\n"
	"	    set r {}\n"
	"	    foreach {k v} [array get v::dbs] {\n"
	"		lappend r $k [lindex $v 0]\n"
	"	    }\n"
	"	    return $r\n"
	"	}\n"
	"	fetch $file\n"
	"	header\n"
	"	if {[get_v] != 0} {\n"
	"	    error \"dbopen?\"\n"
	"	}\n"
	"	set desc [layout [get_s [get_v]]]\n"
	"	lassign [descparse $desc] names types\n"
	"	set root [get_sub $names [list [prepare $types]] 0]\n"
	"	set v::dbs($db) [list $file $v::data $desc [mvec $root 0]]\n"
	"	return $db\n"
	"    }\n"
	"\n"
	"    proc dbclose {db} {\n"
	"	# close datafile, get rid of stored info\n"
	"	unset v::dbs($db)\n"
	"	set v::data \"\" ;# it may be big \n"
	"    }\n"
	"\n"
	"    proc dbtree {db} {\n"
	"	# datafile selection, first step in access navigation loop\n"
	"	return [lindex $v::dbs($db) 3]\n"
	"    }\n"
	"\n"
	"    proc access {spec} {\n"
	"	# this is the main access navigation loop\n"
	"	set s [split $spec \".!\"]\n"
	"	set x [list dbtree [array size v::dbs]]\n"
	"	foreach y $s {\n"
	"	    set x [mvec $x $y]\n"
	"	}\n"
	"	return $x\n"
	"    }\n"
	"\n"
	"    proc vnames {view} {\n"
	"	# return a list of property names\n"
	"	if {[lindex $view 0] != \"get_view\"} {\n"
	"	    error \"vnames?\"\n"
	"	}\n"
	"	return [lindex $view 1]\n"
	"    }\n"
	"\n"
	"    proc vlen {view} {\n"
	"	# return the number of rows in this view\n"
	"	if {[lindex $view 0] != \"get_view\"} {\n"
	"	    error \"vlen?\"\n"
	"	}\n"
	"	return [lindex $view 2]\n"
	"    }\n"
	"\n"
	"    # vim: ft=tcl\n"
	"\n"
	"}\n"
	"\n"
	"if {[info comm mk_file] == \"\"} {\n"
	"    # Compatibility layer for MetaKit\n"
	"\n"
	"    # requires dbopen/dbclose/dbtree/access/vnames/vlen/mvec primitives\n"
	"    #source [file join [info dirname [info script]] decode.tcl]\n"
	"\n"
	"    namespace export mk_*\n"
	"\n"
	"    proc mk_file {cmd args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::file $cmd $args\"\n"
	"	lassign $args db file\n"
	"	switch $cmd {\n"
	"	    open {\n"
	"		    return [dbopen $db $file]\n"
	"		}\n"
	"	    close {\n"
	"		    dbclose $db\n"
	"		}\n"
	"	    views {\n"
	"		    return [vnames [dbtree $db]]\n"
	"		}\n"
	"	    commit {\n"
	"\n"
	"		}\n"
	"	    default {\n"
	"		    error \"mk_file $cmd?\"\n"
	"		}\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc mk_view {cmd path args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::view $cmd $path $args\"\n"
	"	lassign $args a1\n"
	"	switch $cmd {\n"
	"	    info {\n"
	"		    return [vnames [access $path]]\n"
	"		}\n"
	"	    layout {\n"
	"		    set layout \"NOTYET\"\n"
	"		    if {[llength $args] > 0 && $layout != $a1} {\n"
	"			#error \"view restructuring not supported\"\n"
	"		    }\n"
	"		    return $layout\n"
	"		}\n"
	"	    size {\n"
	"		    set len [vlen [access $path]]\n"
	"		    if {[llength $args] > 0 && $len != $a1} {\n"
	"			error \"view resizing not supported\"\n"
	"		    }\n"
	"		    return [vlen [access $path]]\n"
	"		}\n"
	"	    default {\n"
	"		    error \"mk_view $cmd?\"\n"
	"		}\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc mk_cursor {cmd cursor args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::cursor $cmd $cursor $args\"\n"
	"	upvar $cursor v\n"
	"	switch $cmd {\n"
	"	    create {\n"
	"		    NOTYET\n"
	"		}\n"
	"	    incr {\n"
	"		    NOTYET\n"
	"		}\n"
	"	    pos -\n"
	"	    position {\n"
	"		    if {$args != \"\"} {\n"
	"			regsub {!-?\\d+$} $v {} v\n"
	"			append v !$args\n"
	"			return $args\n"
	"		    }\n"
	"		    if {![regexp {\\d+$} $v n]} {\n"
	"			set n -1\n"
	"		    }\n"
	"		    return $n\n"
	"		}\n"
	"	    default {\n"
	"		    error \"mk_cursor $cmd?\"\n"
	"		}\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc mk_get {path args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::get $path $args\"\n"
	"	set rowref [access $path]\n"
	"	set sized 0\n"
	"	if {[lindex $args 0] == \"-size\"} {\n"
	"	    set sized 1\n"
	"	    set args [lrange $args 1 end]\n"
	"	}\n"
	"	set ids 0\n"
	"	if {[llength $args] == 0} {\n"
	"	    set args [vnames $rowref]\n"
	"	    set ids 1\n"
	"	}\n"
	"	set r {}\n"
	"	foreach x $args {\n"
	"	    if {$ids} {\n"
	"		lappend r $x\n"
	"	    }\n"
	"	    set v [mvec $rowref $x]\n"
	"if {[string range $v 0 8] == \"get_view \"} {\n"
	"# XXX: ?!?!?: TODO: FIX\n"
	"set v 1\n"
	"}\n"
	"	    if {$sized} {\n"
	"		lappend r [string length $v]\n"
	"	    } else {\n"
	"		lappend r $v\n"
	"	    }\n"
	"	}\n"
	"	if {[llength $args] == 1} {\n"
	"	    set r [lindex $r 0]\n"
	"	}\n"
	"\n"
	"	return $r\n"
	"    }\n"
	"\n"
	"    proc mk_loop {cursor path args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::loop $cursor $path ...\"\n"
	"	upvar $cursor v\n"
	"	if {[llength $args] == 0} {\n"
	"	    set args [list $path]\n"
	"	    set path $v\n"
	"	    regsub {!-?\\d+$} $path {} path\n"
	"	}\n"
	"	lassign $args a1 a2 a3 a4\n"
	"	set rowref [access $path]\n"
	"	set first 0\n"
	"	set limit [vlen $rowref]\n"
	"	set step 1\n"
	"	switch [llength $args] {\n"
	"	    1 {\n"
	"		    set body $a1\n"
	"		}\n"
	"	    2 {\n"
	"		    set first $a1\n"
	"		    set body $a2\n"
	"		}\n"
	"	    3 {\n"
	"		    set first $a1\n"
	"		    set limit $a2\n"
	"		    set body $a3\n"
	"		}\n"
	"	    4 {\n"
	"		    set first $a1\n"
	"		    set limit $a2\n"
	"		    set step $a3\n"
	"		    set body $a4\n"
	"		}\n"
	"	    default {\n"
	"		    error \"mk_loop arg count?\"\n"
	"		}\n"
	"	}\n"
	"	set code 0\n"
	"	for {set i $first} {$i < $limit} {incr i $step} {\n"
	"	    set v $path!$i\n"
	"	    set code [catch [list uplevel 1 $body] err]\n"
	"	    switch $code {\n"
	"		1 -\n"
	"		2 {\n"
	"			return -code $code $err\n"
	"		    }\n"
	"		3 {\n"
	"			break\n"
	"		    }\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc mk_select {path args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::select $path $args\"\n"
	"	# only handle the simplest case: exact matches\n"
	"	if {[lindex $args 0] == \"-count\"} {\n"
	"		set maxitems [lindex $args 1]\n"
	"		set args [lrange $args 2 end]\n"
	"	}\n"
	"\n"
	"	set currmatchmode \"caseinsensitive\"\n"
	"\n"
	"	set keys {}\n"
	"	set value {}\n"
	"	set matchmodes {}\n"
	"	for {set idx 0} {$idx < [llength $args]} {incr idx 2} {\n"
	"		switch -glob -- [lindex $args $idx] {\n"
	"			\"-glob\" {\n"
	"				set currmatchmode \"glob\"\n"
	"				incr idx -1\n"
	"				continue\n"
	"			}\n"
	"			\"-*\" {\n"
	"				error \"Unhandled option: [lindex $args $idx]\"\n"
	"			}\n"
	"		}\n"
	"\n"
	"		set k [lindex $args $idx]\n"
	"		set v [lindex $args [expr {$idx+1}]]\n"
	"\n"
	"		lappend keys $k\n"
	"		lappend values $v\n"
	"		lappend matchmodes $currmatchmode\n"
	"	}\n"
	"	set r {}\n"
	"	mk_loop c $path {\n"
	"		set x [eval mk_get $c $keys]\n"
	"		set matchCnt 0\n"
	"		for {set idx 0} {$idx < [llength $x]} {incr idx} {\n"
	"			set val [lindex $values $idx]\n"
	"			set chkval [lindex $x $idx]\n"
	"			set matchmode [lindex $matchmodes $idx]\n"
	"\n"
	"			switch -- $matchmode {\n"
	"				\"caseinsensitive\" {\n"
	"					if {$val == $chkval} {\n"
	"						incr matchCnt\n"
	"					}\n"
	"				}\n"
	"				\"glob\" {\n"
	"					if {[string match $val $chkval]} {\n"
	"						incr matchCnt\n"
	"					}\n"
	"				}\n"
	"			}\n"
	"\n"
	"		}\n"
	"		if {$matchCnt == [llength $keys]} {\n"
	"			lappend r [mk_cursor position c]\n"
	"		}\n"
	"	}\n"
	"\n"
	"	if {[info exists maxitems]} {\n"
	"		set r [lrange $r 0 [expr $maxitems - 1]]\n"
	"	}\n"
	"\n"
	"	return $r\n"
	"    }\n"
	"\n"
	"    proc mk__rechan {path prop cmd chan args} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::_rechan $path $prop $cmd $chan $args\"\n"
	"\n"
	"        set key [list $path $prop]\n"
	"        if {![info exists ::mk__cache($key)]} {\n"
	"          set ::mk__cache($key) [readkit::get $path $prop]\n"
	"        }\n"
	"        if {![info exists ::mk__offset($key)]} {\n"
	"          set ::mk__offset($key) 0\n"
	"        }\n"
	"        set data $::mk__cache($key)\n"
	"        set offset $::mk__offset($key)\n"
	"\n"
	"        switch -- $cmd {\n"
	"            \"read\" {\n"
	"                set count [lindex $args 0]\n"
	"                set retval [string range $data $offset [expr {$offset + $count - 1}]]\n"
	"\n"
	"                set readbytes [string length $retval]\n"
	"\n"
	"                incr offset $readbytes\n"
	"            }\n"
	"            \"close\" {\n"
	"                unset -nocomplain ::mk__cache($key)\n"
	"                unset -nocomplain ::mk__offset($key)\n"
	"                return\n"
	"            }\n"
	"            default {\n"
	"#puts stderr \"${indent}DEBUG: readkit::_rechan: Called for cmd $cmd\"\n"
	"                return -code error \"Not implemented: cmd = $cmd\"\n"
	"            }\n"
	"        }\n"
	"\n"
	"        set ::mk__offset($key) $offset\n"
	"\n"
	"	return $retval\n"
	"    }\n"
	"\n"
	"    proc mk_channel {path prop {mode \"r\"}} {\n"
	"#set indent [string repeat \"    \" [info level]]\n"
	"#puts stderr \"${indent}DEBUG: readkit::channel $path $prop $mode\"\n"
	"	set fd [rechan [list mk__rechan $path $prop] 2]\n"
	"\n"
	"	return $fd\n"
	"    }\n"
	"    # vim: ft=tcl\n"
	"\n"
	"}\n"
	"\n"
	"# set up the MetaKit compatibility definitions\n"
	"foreach x {file view cursor get loop select channel} {\n"
	"    interp alias {} ::readkit::$x {} ::mk_$x\n"
	"}\n"
	"\n"
	"\n"
	"\n"
	"# mk4vfs.tcl -- Mk4tcl Virtual File System driver\n"
	"# Copyright (C) 1997-2003 Sensus Consulting Ltd. All Rights Reserved.\n"
	"# Matt Newman <matt@sensus.org> and Jean-Claude Wippler <jcw@equi4.com>\n"
	"#\n"
	"# $Id: mk4vfs.tcl,v 1.41 2008/04/15 21:11:53 andreas_kupries Exp $\n"
	"#\n"
	"# 05apr02 jcw	1.3	fixed append mode & close,\n"
	"#			privatized memchan_handler\n"
	"#			added zip, crc back in\n"
	"# 28apr02 jcw	1.4	reorged memchan and pkg dependencies\n"
	"# 22jun02 jcw	1.5	fixed recursive dir deletion\n"
	"# 16oct02 jcw	1.6	fixed periodic commit once a change is made\n"
	"# 20jan03 jcw	1.7	streamed zlib decompress mode, reduces memory usage\n"
	"# 01feb03 jcw	1.8	fix mounting a symlink, cleanup mount/unmount procs\n"
	"# 04feb03 jcw	1.8	whoops, restored vfs::mkcl::Unmount logic\n"
	"# 17mar03 jcw	1.9	start with mode translucent or readwrite\n"
	"# 18oct05 jcw	1.10	add fallback to MK Compatible Lite driver (vfs::mkcl)\n"
	"\n"
	"# Removed provision of the backward compatible name. Moved to separate\n"
	"# file/package.\n"
	"catch {\n"
	"	load {} vfs\n"
	"}\n"
	"package require vfs\n"
	"\n"
	"# things that can no longer really be left out (but this is the wrong spot!)\n"
	"# be as non-invasive as possible, using these definitions as last resort\n"
	"\n"
	"namespace eval vfs::mkcl {\n"
	"    proc Mount {mkfile local args} {\n"
	"	if {$mkfile != \"\"} {\n"
	"	  # dereference a symlink, otherwise mounting on it fails (why?)\n"
	"	  catch {\n"
	"	    set mkfile [file join [file dirname $mkfile] \\\n"
	"	    			  [file readlink $mkfile]]\n"
	"	  }\n"
	"	  set mkfile [file normalize $mkfile]\n"
	"	}\n"
	"	set db [eval [list ::mkcl_vfs::_mount $mkfile] $args]\n"
	"	::vfs::filesystem mount $local [list ::vfs::mkcl::handler $db]\n"
	"	::vfs::RegisterMount $local [list ::vfs::mkcl::Unmount $db]\n"
	"	return $db\n"
	"    }\n"
	"\n"
	"    proc Unmount {db local} {\n"
	"	vfs::filesystem unmount $local\n"
	"	::mkcl_vfs::_umount $db\n"
	"    }\n"
	"\n"
	"    proc attributes {db} { return [list \"state\" \"commit\"] }\n"
	"    \n"
	"    # Can use this to control commit/nocommit or whatever.\n"
	"    # I'm not sure yet of what functionality jcw needs.\n"
	"    proc commit {db args} {\n"
	"	switch -- [llength $args] {\n"
	"	    0 {\n"
	"		if {$::mkcl_vfs::v::mode($db) == \"readonly\"} {\n"
	"		    return 0\n"
	"		} else {\n"
	"		    # To Do: read the commit state\n"
	"		    return 1\n"
	"		}\n"
	"	    }\n"
	"	    1 {\n"
	"		set val [lindex $args 0]\n"
	"		if {$val != 0 && $val != 1} {\n"
	"		    return -code error \\\n"
	"		      \"invalid commit value $val, must be 0,1\"\n"
	"		}\n"
	"		# To Do: set the commit state.\n"
	"	    }\n"
	"	    default {\n"
	"		return -code error \"Wrong num args\"\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"    \n"
	"    proc state {db args} {\n"
	"	switch -- [llength $args] {\n"
	"	    0 {\n"
	"		return $::mkcl_vfs::v::mode($db)\n"
	"	    }\n"
	"	    1 {\n"
	"		set val [lindex $args 0]\n"
	"		if {[lsearch -exact [::vfs::states] $val] == -1} {\n"
	"		    return -code error \\\n"
	"		      \"invalid state $val, must be one of: [vfs::states]\"\n"
	"		}\n"
	"		set ::mkcl_vfs::v::mode($db) $val\n"
	"		::mkcl_vfs::setupCommits $db\n"
	"	    }\n"
	"	    default {\n"
	"		return -code error \"Wrong num args\"\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"    \n"
	"    proc handler {db cmd root relative actualpath args} {\n"
	"	#puts stderr \"handler: $db - $cmd - $root - $relative - $actualpath - $args\"\n"
	"	if {$cmd == \"matchindirectory\"} {\n"
	"	    eval [list $cmd $db $relative $actualpath] $args\n"
	"	} elseif {$cmd == \"fileattributes\"} {\n"
	"	    eval [list $cmd $db $root $relative] $args\n"
	"	} else {\n"
	"	    eval [list $cmd $db $relative] $args\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc utime {db path actime modtime} {\n"
	"	::mkcl_vfs::stat $db $path sb\n"
	"	\n"
	"	if { $sb(type) == \"file\" } {\n"
	"	    readkit::set $sb(ino) date $modtime\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc matchindirectory {db path actualpath pattern type} {\n"
	"	set newres [list]\n"
	"	if {![string length $pattern]} {\n"
	"	    # check single file\n"
	"	    if {[catch {access $db $path 0}]} {\n"
	"		return {}\n"
	"	    }\n"
	"	    set res [list $actualpath]\n"
	"	    set actualpath \"\"\n"
	"	} else {\n"
	"	    set res [::mkcl_vfs::getdir $db $path $pattern]\n"
	"	}\n"
	"	foreach p [::vfs::matchCorrectTypes $type $res $actualpath] {\n"
	"	    lappend newres [file join $actualpath $p]\n"
	"	}\n"
	"	return $newres\n"
	"    }\n"
	"\n"
	"    proc stat {db name} {\n"
	"	::mkcl_vfs::stat $db $name sb\n"
	"\n"
	"	set sb(ino) 0\n"
	"	array get sb\n"
	"    }\n"
	"\n"
	"    proc access {db name mode} {\n"
	"	if {$mode & 2} {\n"
	"	    if {$::mkcl_vfs::v::mode($db) == \"readonly\"} {\n"
	"		vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	    }\n"
	"	}\n"
	"	# We can probably do this more efficiently, can't we?\n"
	"	::mkcl_vfs::stat $db $name sb\n"
	"    }\n"
	"\n"
	"    proc open {db file mode permissions} {\n"
	"	# return a list of two elements:\n"
	"	# 1. first element is the Tcl channel name which has been opened\n"
	"	# 2. second element (optional) is a command to evaluate when\n"
	"	#  the channel is closed.\n"
	"	switch -glob -- $mode {\n"
	"	    {}  -\n"
	"	    r {\n"
	"		::mkcl_vfs::stat $db $file sb\n"
	"\n"
	"		if { $sb(csize) != $sb(size) } {\n"
	"		    if {$::mkcl_vfs::zstreamed} {\n"
	"		      set fd [readkit::channel $sb(ino) contents r]\n"
	"		      fconfigure $fd -translation binary\n"
	"		      set fd [vfs::zstream decompress $fd $sb(csize) $sb(size)]\n"
	"		    } else {\n"
	"		      set fd [vfs::memchan]\n"
	"		      fconfigure $fd -translation binary\n"
	"		      set s [readkit::get $sb(ino) contents]\n"
	"		      puts -nonewline $fd [vfs::zip -mode decompress $s]\n"
	"\n"
	"		      fconfigure $fd -translation auto\n"
	"		      seek $fd 0\n"
	"		    }\n"
	"		} elseif { $::mkcl_vfs::direct } {\n"
	"		    set fd [vfs::memchan]\n"
	"		    fconfigure $fd -translation binary\n"
	"		    puts -nonewline $fd [readkit::get $sb(ino) contents]\n"
	"\n"
	"		    fconfigure $fd -translation auto\n"
	"		    seek $fd 0\n"
	"		} else {\n"
	"		    set fd [readkit::channel $sb(ino) contents r]\n"
	"		}\n"
	"		return [list $fd]\n"
	"	    }\n"
	"	    a {\n"
	"		if {$::mkcl_vfs::v::mode($db) == \"readonly\"} {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"		}\n"
	"		if { [catch {::mkcl_vfs::stat $db $file sb }] } {\n"
	"		    # Create file\n"
	"		    ::mkcl_vfs::stat $db [file dirname $file] sb\n"
	"		    set tail [file tail $file]\n"
	"		    set fview $sb(ino).files\n"
	"		    if {[info exists mkcl_vfs::v::fcache($fview)]} {\n"
	"			lappend mkcl_vfs::v::fcache($fview) $tail\n"
	"		    }\n"
	"		    set now [clock seconds]\n"
	"		    set sb(ino) [readkit::row append $fview \\\n"
	"			    name $tail size 0 date $now ]\n"
	"\n"
	"		    if { [string match *z* $mode] || $mkcl_vfs::compress } {\n"
	"			set sb(csize) -1  ;# HACK - force compression\n"
	"		    } else {\n"
	"			set sb(csize) 0\n"
	"		    }\n"
	"		}\n"
	"\n"
	"		set fd [vfs::memchan]\n"
	"		fconfigure $fd -translation binary\n"
	"		set s [readkit::get $sb(ino) contents]\n"
	"\n"
	"		if { $sb(csize) != $sb(size) && $sb(csize) > 0 } {\n"
	"		    append mode z\n"
	"		    puts -nonewline $fd [vfs::zip -mode decompress $s]\n"
	"		} else {\n"
	"		    if { $mkcl_vfs::compress } { append mode z }\n"
	"		    puts -nonewline $fd $s\n"
	"		    #set fd [readkit::channel $sb(ino) contents a]\n"
	"		}\n"
	"		fconfigure $fd -translation auto\n"
	"		seek $fd 0 end\n"
	"		return [list $fd [list mkcl_vfs::do_close $db $fd $mode $sb(ino)]]\n"
	"	    }\n"
	"	    w*  {\n"
	"		if {$::mkcl_vfs::v::mode($db) == \"readonly\"} {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"		}\n"
	"		if { [catch {::mkcl_vfs::stat $db $file sb }] } {\n"
	"		    # Create file\n"
	"		    ::mkcl_vfs::stat $db [file dirname $file] sb\n"
	"		    set tail [file tail $file]\n"
	"		    set fview $sb(ino).files\n"
	"		    if {[info exists mkcl_vfs::v::fcache($fview)]} {\n"
	"			lappend mkcl_vfs::v::fcache($fview) $tail\n"
	"		    }\n"
	"		    set now [clock seconds]\n"
	"		    set sb(ino) [readkit::row append $fview \\\n"
	"			    name $tail size 0 date $now ]\n"
	"		}\n"
	"\n"
	"		if { [string match *z* $mode] || $mkcl_vfs::compress } {\n"
	"		    append mode z\n"
	"		    set fd [vfs::memchan]\n"
	"		} else {\n"
	"		    set fd [readkit::channel $sb(ino) contents w]\n"
	"		}\n"
	"		return [list $fd [list mkcl_vfs::do_close $db $fd $mode $sb(ino)]]\n"
	"	    }\n"
	"	    default   {\n"
	"		error \"illegal access mode \\\"$mode\\\"\"\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc createdirectory {db name} {\n"
	"	mkcl_vfs::mkdir $db $name\n"
	"    }\n"
	"\n"
	"    proc removedirectory {db name recursive} {\n"
	"	mkcl_vfs::delete $db $name $recursive\n"
	"    }\n"
	"\n"
	"    proc deletefile {db name} {\n"
	"	mkcl_vfs::delete $db $name\n"
	"    }\n"
	"\n"
	"    proc fileattributes {db root relative args} {\n"
	"	switch -- [llength $args] {\n"
	"	    0 {\n"
	"		# list strings\n"
	"		return [::vfs::listAttributes]\n"
	"	    }\n"
	"	    1 {\n"
	"		# get value\n"
	"		set index [lindex $args 0]\n"
	"		return [::vfs::attributesGet $root $relative $index]\n"
	"\n"
	"	    }\n"
	"	    2 {\n"
	"		# set value\n"
	"		if {$::mkcl_vfs::v::mode($db) == \"readonly\"} {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"		}\n"
	"		set index [lindex $args 0]\n"
	"		set val [lindex $args 1]\n"
	"		return [::vfs::attributesSet $root $relative $index $val]\n"
	"	    }\n"
	"	}\n"
	"    }\n"
	"}\n"
	"\n"
	"namespace eval mkcl_vfs {\n"
	"    variable compress 1     ;# HACK - needs to be part of \"Super-Block\"\n"
	"    variable flush    5000  ;# Auto-Commit frequency\n"
	"    variable direct   0	    ;# read through a memchan, or from Mk4tcl if zero\n"
	"    variable zstreamed 1    ;# decompress on the fly (needs zlib 1.1)\n"
	"\n"
	"    namespace eval v {\n"
	"	variable seq      0\n"
	"	variable mode	    ;# array key is db, value is mode \n"
	"	             	     # (readwrite/translucent/readonly)\n"
	"	variable timer	    ;# array key is db, set to afterid, periodicCommit\n"
	"\n"
	"	array set cache {}\n"
	"	array set fcache {}\n"
	"\n"
	"	array set mode {exe translucent}\n"
	"    }\n"
	"\n"
	"    proc init {db} {\n"
	"	readkit::view layout $db.dirs \\\n"
	"		{name:S parent:I {files {name:S size:I date:I contents:M}}}\n"
	"\n"
	"	if { [readkit::view size $db.dirs] == 0 } {\n"
	"	    readkit::row append $db.dirs name <root> parent -1\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc _mount {{file \"\"} args} {\n"
	"	set db mk4vfs[incr v::seq]\n"
	"\n"
	"	if {$file == \"\"} {\n"
	"	    readkit::file open $db\n"
	"	    init $db\n"
	"	    set v::mode($db) \"translucent\"\n"
	"	} else {\n"
	"	    eval [list readkit::file open $db $file] $args\n"
	"	    \n"
	"	    init $db\n"
	"	    \n"
	"	    set mode 0\n"
	"	    foreach arg $args {\n"
	"		switch -- $arg {\n"
	"		    -readonly   { set mode 1 }\n"
	"		    -nocommit   { set mode 2 }\n"
	"		}\n"
	"	    }\n"
	"	    if {$mode == 0} {\n"
	"		periodicCommit $db\n"
	"	    }\n"
	"	    set v::mode($db) [lindex {translucent readwrite readwrite} $mode]\n"
	"	}\n"
	"	return $db\n"
	"    }\n"
	"\n"
	"    proc periodicCommit {db} {\n"
	"	variable flush\n"
	"	set v::timer($db) [after $flush [list ::mkcl_vfs::periodicCommit $db]]\n"
	"	readkit::file commit $db\n"
	"	return ;# 2005-01-20 avoid returning a value\n"
	"    }\n"
	"\n"
	"    proc _umount {db args} {\n"
	"	catch {after cancel $v::timer($db)}\n"
	"	array unset v::mode $db\n"
	"	array unset v::timer $db\n"
	"	array unset v::cache $db,*\n"
	"	array unset v::fcache $db.*\n"
	"	readkit::file close $db\n"
	"    }\n"
	"\n"
	"    proc stat {db path {arr \"\"}} {\n"
	"	set sp [::file split $path]\n"
	"	set tail [lindex $sp end]\n"
	"\n"
	"	set parent 0\n"
	"	set view $db.dirs\n"
	"	set type directory\n"
	"\n"
	"	foreach ele [lrange $sp 0 end-1] {\n"
	"	    if {[info exists v::cache($db,$parent,$ele)]} {\n"
	"		set parent $v::cache($db,$parent,$ele)\n"
	"	    } else {\n"
	"		set row [readkit::select $view -count 1 parent $parent name $ele]\n"
	"		if { $row == \"\" } {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(ENOENT)\n"
	"		}\n"
	"		set v::cache($db,$parent,$ele) $row\n"
	"		set parent $row\n"
	"	    }\n"
	"	}\n"
	"	\n"
	"	# Now check if final comp is a directory or a file\n"
	"	# CACHING is required - it can deliver a x15 speed-up!\n"
	"	\n"
	"	if { [string equal $tail \".\"] || [string equal $tail \":\"] \\\n"
	"	  || [string equal $tail \"\"] } {\n"
	"	    set row $parent\n"
	"\n"
	"	} elseif { [info exists v::cache($db,$parent,$tail)] } {\n"
	"	    set row $v::cache($db,$parent,$tail)\n"
	"	} else {\n"
	"	    # File?\n"
	"	    set fview $view!$parent.files\n"
	"	    # create a name cache of files in this directory\n"
	"	    if {![info exists v::fcache($fview)]} {\n"
	"		# cache only a limited number of directories\n"
	"		if {[array size v::fcache] >= 10} {\n"
	"		    array unset v::fcache *\n"
	"		}\n"
	"		set v::fcache($fview) {}\n"
	"		readkit::loop c $fview {\n"
	"		    lappend v::fcache($fview) [readkit::get $c name]\n"
	"		}\n"
	"	    }\n"
	"	    set row [lsearch -exact $v::fcache($fview) $tail]\n"
	"	    #set row [readkit::select $fview -count 1 name $tail]\n"
	"	    #if {$row == \"\"} { set row -1 }\n"
	"	    if { $row != -1 } {\n"
	"		set type file\n"
	"		set view $view!$parent.files\n"
	"	    } else {\n"
	"		# Directory?\n"
	"		set row [readkit::select $view -count 1 parent $parent name $tail]\n"
	"		if { $row != \"\" } {\n"
	"		    set v::cache($db,$parent,$tail) $row\n"
	"		} else { \n"
	"		    vfs::filesystem posixerror $::vfs::posix(ENOENT)\n"
	"		}\n"
	"	    }\n"
	"	}\n"
	" \n"
	"        if {![string length $arr]} {\n"
	"            # The caller doesn't need more detailed information.\n"
	"            return 1\n"
	"        }\n"
	" \n"
	"	set cur $view!$row\n"
	"\n"
	"	upvar 1 $arr sb\n"
	"\n"
	"	set sb(type)    $type\n"
	"	set sb(view)    $view\n"
	"	set sb(ino)     $cur\n"
	"\n"
	"	if { [string equal $type \"directory\"] } {\n"
	"	    set sb(atime) 0\n"
	"	    set sb(ctime) 0\n"
	"	    set sb(gid)   0\n"
	"	    set sb(mode)  0777\n"
	"	    set sb(mtime) 0\n"
	"	    set sb(nlink) [expr { [readkit::get $cur files] + 1 }]\n"
	"	    set sb(size)  0\n"
	"	    set sb(csize) 0\n"
	"	    set sb(uid)   0\n"
	"	} else {\n"
	"	    set mtime   [readkit::get $cur date]\n"
	"	    set sb(atime) $mtime\n"
	"	    set sb(ctime) $mtime\n"
	"	    set sb(gid)   0\n"
	"	    set sb(mode)  0777\n"
	"	    set sb(mtime) $mtime\n"
	"	    set sb(nlink) 1\n"
	"	    set sb(size)  [readkit::get $cur size]\n"
	"	    set sb(csize) [readkit::get $cur -size contents]\n"
	"	    set sb(uid)   0\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc do_close {db fd mode cur} {\n"
	"	if {![regexp {[aw]} $mode]} {\n"
	"	    error \"mkcl_vfs::do_close called with bad mode: $mode\"\n"
	"	}\n"
	"\n"
	"	readkit::set $cur size -1 date [clock seconds]\n"
	"	flush $fd\n"
	"	if { [string match *z* $mode] } {\n"
	"	    fconfigure $fd -translation binary\n"
	"	    seek $fd 0\n"
	"	    set data [read $fd]\n"
	"	    set cdata [vfs::zip -mode compress $data]\n"
	"	    set len [string length $data]\n"
	"	    set clen [string length $cdata]\n"
	"	    if { $clen < $len } {\n"
	"		readkit::set $cur size $len contents $cdata\n"
	"	    } else {\n"
	"		readkit::set $cur size $len contents $data\n"
	"	    }\n"
	"	} else {\n"
	"	    readkit::set $cur size [readkit::get $cur -size contents]\n"
	"	}\n"
	"	# 16oct02 new logic to start a periodic commit timer if not yet running\n"
	"	setupCommits $db\n"
	"	return \"\"\n"
	"    }\n"
	"\n"
	"    proc setupCommits {db} {\n"
	"	if {$v::mode($db) eq \"readwrite\" && ![info exists v::timer($db)]} {\n"
	"	    periodicCommit $db\n"
	"	    readkit::file autocommit $db\n"
	"	}\n"
	"    }\n"
	"\n"
	"    proc mkdir {db path} {\n"
	"	if {$v::mode($db) == \"readonly\"} {\n"
	"	    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	}\n"
	"	set sp [::file split $path]\n"
	"	set parent 0\n"
	"	set view $db.dirs\n"
	"\n"
	"	set npath {}\n"
	"	# This actually does more work than is needed. Tcl's\n"
	"	# vfs only requires us to create the last piece, and\n"
	"	# Tcl already knows it is not a file.\n"
	"	foreach ele $sp {\n"
	"	    set npath [file join $npath $ele]\n"
	"\n"
	"	    if {![catch {stat $db $npath sb}] } {\n"
	"		if { $sb(type) != \"directory\" } {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"		}\n"
	"		set parent [readkit::cursor position sb(ino)]\n"
	"		continue\n"
	"	    }\n"
	"	    #set parent [readkit::cursor position sb(ino)]\n"
	"	    set cur [readkit::row append $view name $ele parent $parent]\n"
	"	    set parent [readkit::cursor position cur]\n"
	"	}\n"
	"	setupCommits $db\n"
	"	return \"\"\n"
	"    }\n"
	"\n"
	"    proc getdir {db path {pat *}} {\n"
	"	if {[catch { stat $db $path sb }] || $sb(type) != \"directory\" } {\n"
	"	    return\n"
	"	}\n"
	"\n"
	"	# Match directories\n"
	"	set parent [readkit::cursor position sb(ino)] \n"
	"	foreach row [readkit::select $sb(view) parent $parent -glob name $pat] {\n"
	"	    set hits([readkit::get $sb(view)!$row name]) 1\n"
	"	}\n"
	"	# Match files\n"
	"	set view $sb(view)!$parent.files\n"
	"	foreach row [readkit::select $view -glob name $pat] {\n"
	"	    set hits([readkit::get $view!$row name]) 1\n"
	"	}\n"
	"	return [lsort [array names hits]]\n"
	"    }\n"
	"\n"
	"    proc mtime {db path time} {\n"
	"	if {$v::mode($db) == \"readonly\"} {\n"
	"	    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	}\n"
	"	stat $db $path sb\n"
	"	if { $sb(type) == \"file\" } {\n"
	"	    readkit::set $sb(ino) date $time\n"
	"	}\n"
	"	return $time\n"
	"    }\n"
	"\n"
	"    proc delete {db path {recursive 0}} {\n"
	"	#puts stderr \"mk4delete db $db path $path recursive $recursive\"\n"
	"	if {$v::mode($db) == \"readonly\"} {\n"
	"	    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	}\n"
	"	stat $db $path sb\n"
	"	if {$sb(type) == \"file\" } {\n"
	"	    readkit::row delete $sb(ino)\n"
	"	    if {[regexp {(.*)!(\\d+)} $sb(ino) - v r] \\\n"
	"		    && [info exists v::fcache($v)]} {\n"
	"		set v::fcache($v) [lreplace $v::fcache($v) $r $r]\n"
	"	    }\n"
	"	} else {\n"
	"	    # just mark dirs as deleted\n"
	"	    set contents [getdir $db $path *]\n"
	"	    if {$recursive} {\n"
	"		# We have to delete these manually, else\n"
	"		# they (or their cache) may conflict with\n"
	"		# something later\n"
	"		foreach f $contents {\n"
	"		    delete $db [file join $path $f] $recursive\n"
	"		}\n"
	"	    } else {\n"
	"		if {[llength $contents]} {\n"
	"		    vfs::filesystem posixerror $::vfs::posix(ENOTEMPTY)\n"
	"		}\n"
	"	    }\n"
	"	    array unset v::cache \\\n"
	"		    \"$db,[readkit::get $sb(ino) parent],[file tail $path]\"\n"
	"	    \n"
	"	    # flag with -99, because parent -1 is not reserved for the root dir\n"
	"	    # deleted entries never get re-used, should be cleaned up one day\n"
	"	    readkit::set $sb(ino) parent -99 name \"\"\n"
	"	    # get rid of file entries to release the space in the datafile\n"
	"	    readkit::view size $sb(ino).files 0\n"
	"	}\n"
	"	setupCommits $db\n"
	"	return \"\"\n"
	"    }\n"
	"}\n"
	"\n"
	"package provide readkit 0.8\n"
	"package provide vfs::mkcl 2.4.0.1\n"
