	"# Removed provision of the backward compatible name. Moved to separate\n"
	"# file/package.\n"
	"\n"
	"package require vfs\n"
	"\n"
	"# Using the vfs, memchan and Trf extensions, we ought to be able\n"
	"# to write a Tcl-only zip virtual filesystem.  What we have below\n"
	"# is basically that.\n"
	"\n"
	"namespace eval vfs::zip {}\n"
	"\n"
	"# Used to execute a zip archive.  This is rather like a jar file\n"
	"# but simpler.  We simply mount it and then source a toplevel\n"
	"# file called 'main.tcl'.\n"
	"proc vfs::zip::Execute {zipfile} {\n"
	"    Mount $zipfile $zipfile\n"
	"    source [file join $zipfile main.tcl]\n"
	"}\n"
	"\n"
	"proc vfs::zip::Mount {zipfile local} {\n"
	"    set fd [::zip::open [::file normalize $zipfile]]\n"
	"    vfs::filesystem mount $local [list ::vfs::zip::handler $fd]\n"
	"    # Register command to unmount\n"
	"    vfs::RegisterMount $local [list ::vfs::zip::Unmount $fd]\n"
	"    return $fd\n"
	"}\n"
	"\n"
	"proc vfs::zip::Unmount {fd local} {\n"
	"    vfs::filesystem unmount $local\n"
	"    ::zip::_close $fd\n"
	"}\n"
	"\n"
	"proc vfs::zip::handler {zipfd cmd root relative actualpath args} {\n"
	"    #::vfs::log [list $zipfd $cmd $root $relative $actualpath $args]\n"
	"    if {$cmd == \"matchindirectory\"} {\n"
	"	eval [list $cmd $zipfd $relative $actualpath] $args\n"
	"    } else {\n"
	"	eval [list $cmd $zipfd $relative] $args\n"
	"    }\n"
	"}\n"
	"\n"
	"proc vfs::zip::attributes {zipfd} { return [list \"state\"] }\n"
	"proc vfs::zip::state {zipfd args} {\n"
	"    vfs::attributeCantConfigure \"state\" \"readonly\" $args\n"
	"}\n"
	"\n"
	"# If we implement the commands below, we will have a perfect\n"
	"# virtual file system for zip files.\n"
	"\n"
	"proc vfs::zip::matchindirectory {zipfd path actualpath pattern type} {\n"
	"    #::vfs::log [list matchindirectory $path $actualpath $pattern $type]\n"
	"\n"
	"    # This call to zip::getdir handles empty patterns properly as asking\n"
	"    # for the existence of a single file $path only\n"
	"    set res [::zip::getdir $zipfd $path $pattern]\n"
	"    #::vfs::log \"got $res\"\n"
	"    if {![string length $pattern]} {\n"
	"	if {![::zip::exists $zipfd $path]} { return {} }\n"
	"	set res [list $actualpath]\n"
	"	set actualpath \"\"\n"
	"    }\n"
	"\n"
	"    set newres [list]\n"
	"    foreach p [::vfs::matchCorrectTypes $type $res $actualpath] {\n"
	"	lappend newres [file join $actualpath $p]\n"
	"    }\n"
	"    #::vfs::log \"got $newres\"\n"
	"    return $newres\n"
	"}\n"
	"\n"
	"proc vfs::zip::stat {zipfd name} {\n"
	"    #::vfs::log \"stat $name\"\n"
	"    ::zip::stat $zipfd $name sb\n"
	"    #::vfs::log [array get sb]\n"
	"    array get sb\n"
	"}\n"
	"\n"
	"proc vfs::zip::access {zipfd name mode} {\n"
	"    #::vfs::log \"zip-access $name $mode\"\n"
	"    if {$mode & 2} {\n"
	"	vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"    }\n"
	"    # Readable, Exists and Executable are treated as 'exists'\n"
	"    # Could we get more information from the archive?\n"
	"    if {[::zip::exists $zipfd $name]} {\n"
	"	return 1\n"
	"    } else {\n"
	"	error \"No such file\"\n"
	"    }\n"
	"    \n"
	"}\n"
	"\n"
	"proc vfs::zip::open {zipfd name mode permissions} {\n"
	"    #::vfs::log \"open $name $mode $permissions\"\n"
	"    # return a list of two elements:\n"
	"    # 1. first element is the Tcl channel name which has been opened\n"
	"    # 2. second element (optional) is a command to evaluate when\n"
	"    #    the channel is closed.\n"
	"\n"
	"    switch -- $mode {\n"
	"	\"\" -\n"
	"	\"r\" {\n"
	"	    if {![::zip::exists $zipfd $name]} {\n"
	"		vfs::filesystem posixerror $::vfs::posix(ENOENT)\n"
	"	    }\n"
	"	    \n"
	"	    ::zip::stat $zipfd $name sb\n"
	"\n"
	"	    set nfd [vfs::memchan]\n"
	"	    fconfigure $nfd -translation binary\n"
	"\n"
	"	    seek $zipfd $sb(ino) start\n"
	"	    zip::Data $zipfd sb data\n"
	"\n"
	"	    puts -nonewline $nfd $data\n"
	"\n"
	"	    fconfigure $nfd -translation auto\n"
	"	    seek $nfd 0\n"
	"	    return [list $nfd]\n"
	"	}\n"
	"	default {\n"
	"	    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	}\n"
	"    }\n"
	"}\n"
	"\n"
	"proc vfs::zip::createdirectory {zipfd name} {\n"
	"    #::vfs::log \"createdirectory $name\"\n"
	"    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"}\n"
	"\n"
	"proc vfs::zip::removedirectory {zipfd name recursive} {\n"
	"    #::vfs::log \"removedirectory $name\"\n"
	"    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"}\n"
	"\n"
	"proc vfs::zip::deletefile {zipfd name} {\n"
	"    #::vfs::log \"deletefile $name\"\n"
	"    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"}\n"
	"\n"
	"proc vfs::zip::fileattributes {zipfd name args} {\n"
	"    #::vfs::log \"fileattributes $args\"\n"
	"    switch -- [llength $args] {\n"
	"	0 {\n"
	"	    # list strings\n"
	"	    return [list]\n"
	"	}\n"
	"	1 {\n"
	"	    # get value\n"
	"	    set index [lindex $args 0]\n"
	"	    return \"\"\n"
	"	}\n"
	"	2 {\n"
	"	    # set value\n"
	"	    set index [lindex $args 0]\n"
	"	    set val [lindex $args 1]\n"
	"	    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"	}\n"
	"    }\n"
	"}\n"
	"\n"
	"proc vfs::zip::utime {fd path actime mtime} {\n"
	"    vfs::filesystem posixerror $::vfs::posix(EROFS)\n"
	"}\n"
	"\n"
	"# Below copied from TclKit distribution\n"
	"\n"
	"#\n"
	"# ZIP decoder:\n"
	"#\n"
	"# Format of zip file:\n"
	"# [ Data ]* [ TOC ]* EndOfArchive\n"
	"#\n"
	"# Note: TOC is refered to in ZIP doc as \"Central Archive\"\n"
	"#\n"
	"# This means there are two ways of accessing:\n"
	"#\n"
	"# 1) from the begining as a stream - until the header\n"
	"#	is not \"PK\\03\\04\" - ideal for unzipping.\n"
	"#\n"
	"# 2) for table of contents without reading entire\n"
	"#	archive by first fetching EndOfArchive, then\n"
	"#	just loading the TOC\n"
	"#\n"
	"\n"
	"namespace eval zip {\n"
	"    array set methods {\n"
	"	0	{stored - The file is stored (no compression)}\n"
	"	1	{shrunk - The file is Shrunk}\n"
	"	2	{reduce1 - The file is Reduced with compression factor 1}\n"
	"	3	{reduce2 - The file is Reduced with compression factor 2}\n"
	"	4	{reduce3 - The file is Reduced with compression factor 3}\n"
	"	5	{reduce4 - The file is Reduced with compression factor 4}\n"
	"	6	{implode - The file is Imploded}\n"
	"	7	{reserved - Reserved for Tokenizing compression algorithm}\n"
	"	8	{deflate - The file is Deflated}\n"
	"	9	{reserved - Reserved for enhanced Deflating}\n"
	"	10	{pkimplode - PKWARE Date Compression Library Imploding}\n"
	"    }\n"
	"    # Version types (high-order byte)\n"
	"    array set systems {\n"
	"	0	{dos}\n"
	"	1	{amiga}\n"
	"	2	{vms}\n"
	"	3	{unix}\n"
	"	4	{vm cms}\n"
	"	5	{atari}\n"
	"	6	{os/2}\n"
	"	7	{macos}\n"
	"	8	{z system 8}\n"
	"	9	{cp/m}\n"
	"	10	{tops20}\n"
	"	11	{windows}\n"
	"	12	{qdos}\n"
	"	13	{riscos}\n"
	"	14	{vfat}\n"
	"	15	{mvs}\n"
	"	16	{beos}\n"
	"	17	{tandem}\n"
	"	18	{theos}\n"
	"    }\n"
	"    # DOS File Attrs\n"
	"    array set dosattrs {\n"
	"	1	{readonly}\n"
	"	2	{hidden}\n"
	"	4	{system}\n"
	"	8	{unknown8}\n"
	"	16	{directory}\n"
	"	32	{archive}\n"
	"	64	{unknown64}\n"
	"	128	{normal}\n"
	"    }\n"
	"\n"
	"    proc u_short {n}  { return [expr { ($n+0x10000)%0x10000 }] }\n"
	"}\n"
	"\n"
	"proc zip::DosTime {date time} {\n"
	"    # The pre-VFS environment will not have access to \"clock\", so don't even\n"
	"    # bother\n"
	"    return 0\n"
	"\n"
	"    set time [u_short $time]\n"
	"    set date [u_short $date]\n"
	"\n"
	"    # time = fedcba9876543210\n"
	"    #        HHHHHmmmmmmSSSSS (sec/2 actually)\n"
	"\n"
	"    # data = fedcba9876543210\n"
	"    #        yyyyyyyMMMMddddd\n"
	"\n"
	"    set sec  [expr { ($time & 0x1F) * 2 }]\n"
	"    set min  [expr { ($time >> 5) & 0x3F }]\n"
	"    set hour [expr { ($time >> 11) & 0x1F }]\n"
	"\n"
	"    set mday [expr { $date & 0x1F }]\n"
	"    set mon  [expr { (($date >> 5) & 0xF) }]\n"
	"    set year [expr { (($date >> 9) & 0xFF) + 1980 }]\n"
	"\n"
	"    # Fix up bad date/time data, no need to fail\n"
	"    if {$sec  > 59} {set sec  59}\n"
	"    if {$min  > 59} {set sec  59}\n"
	"    if {$hour > 23} {set hour 23}\n"
	"    if {$mday < 1}  {set mday 1}\n"
	"    if {$mday > 35} {set mday 35}\n"
	"    if {$mon  < 1}  {set mon  1}\n"
	"    if {$mon > 12}  {set mon  12}\n"
	"\n"
	"    set res 0\n"
	"    while {$mday > 1 && [catch {\n"
	"	set dt [format {%4.4d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d} \\\n"
	"		    $year $mon $mday $hour $min $sec]\n"
	"	set res [clock scan $dt -gmt 1]\n"
	"    }]} {\n"
	"	# Only mday can be wrong, at end of month\n"
	"	incr mday -1\n"
	"    }\n"
	"\n"
	"    return $res\n"
	"}\n"
	"\n"
	"\n"
	"proc zip::Data {fd arr {varPtr \"\"} {verify 0}} {\n"
	"    upvar 1 $arr sb\n"
	"\n"
	"    if { $varPtr != \"\" } {\n"
	"	upvar 1 $varPtr data\n"
	"    }\n"
	"\n"
	"    set buf [read $fd 30]\n"
	"    set n [binary scan $buf A4sssssiiiss \\\n"
	"		hdr sb(ver) sb(flags) sb(method) \\\n"
	"		time date \\\n"
	"		sb(crc) sb(csize) sb(size) flen elen]\n"
	"\n"
	"    if { ![string equal \"PK\\03\\04\" $hdr] } {\n"
	"	binary scan $hdr H* x\n"
	"	error \"bad header: $x\"\n"
	"    }\n"
	"    set sb(ver)		[u_short $sb(ver)]\n"
	"    set sb(flags)	[u_short $sb(flags)]\n"
	"    set sb(method)	[u_short $sb(method)]\n"
	"    set sb(mtime)	[DosTime $date $time]\n"
	"\n"
	"    set sb(name) [read $fd [u_short $flen]]\n"
	"    set sb(extra) [read $fd [u_short $elen]]\n"
	"\n"
	"    if { $varPtr == \"\" } {\n"
	"	seek $fd $sb(csize) current\n"
	"    } else {\n"
	"	# Added by Chuck Ferril 10-26-03 to fix reading of OpenOffice\n"
	"	#  .sxw files. Any files in the zip that had a method of 8\n"
	"	#  (deflate) failed here because size and csize were zero.\n"
	"	#  I'm not sure why the above computes the size and csize\n"
	"	#  wrong, but stat appears works properly. I originally\n"
	"	#  checked for csize of zero, but adding this change didn't\n"
	"	#  appear to break the none deflated file access and seemed\n"
	"	#  more natural.\n"
	" 	zip::stat $fd $sb(name) sb\n"
	"\n"
	"	set data [read $fd $sb(csize)]\n"
	"    }\n"
	"\n"
	"    if { $sb(flags) & 0x4 } {\n"
	"	# Data Descriptor used\n"
	"	set buf [read $fd 12]\n"
	"	binary scan $buf iii sb(crc) sb(csize) sb(size)\n"
	"    }\n"
	"\n"
	"\n"
	"    if { $varPtr == \"\" } {\n"
	"	return \"\"\n"
	"    }\n"
	"\n"
	"    if { $sb(method) != 0 } {\n"
	"	if { [catch {\n"
	"	    set data [vfs::zip -mode decompress -nowrap 1 $data]\n"
	"	} err] } {\n"
	"	    ::vfs::log \"$sb(name): inflate error: $err\"\n"
	"	    binary scan $data H* x\n"
	"	    ::vfs::log $x\n"
	"	}\n"
	"    }\n"
	"    return\n"
	"    if { $verify } {\n"
	"	set ncrc [vfs::crc $data]\n"
	"	if { $ncrc != $sb(crc) } {\n"
	"	    tclLog [format {%s: crc mismatch: expected 0x%x, got 0x%x} \\\n"
	"		    $sb(name) $sb(crc) $ncrc]\n"
	"	}\n"
	"    }\n"
	"}\n"
	"\n"
	"proc zip::EndOfArchive {fd arr} {\n"
	"    upvar 1 $arr cb\n"
	"\n"
	"    # [SF Tclvfs Bug 1003574]. Do not seek over beginning of file.\n"
	"    seek $fd 0 end\n"
	"\n"
	"    # Just looking in the last 512 bytes may be enough to handle zip\n"
	"    # archives without comments, however for archives which have\n"
	"    # comments the chunk may start at an arbitrary distance from the\n"
	"    # end of the file. So if we do not find the header immediately\n"
	"    # we have to extend the range of our search, possibly until we\n"
	"    # have a large part of the archive in memory. We can fail only\n"
	"    # after the whole file has been searched.\n"
	"\n"
	"    set sz  [tell $fd]\n"
	"    set len 512\n"
	"    set at  512\n"
	"    while {1} {\n"
	"	if {$sz < $at} {set n -$sz} else {set n -$at}\n"
	"\n"
	"	seek $fd $n end\n"
	"	set hdr [read $fd $len]\n"
	"	set pos [string first \"PK\\05\\06\" $hdr]\n"
	"	if {$pos == -1} {\n"
	"	    if {$at >= $sz} {\n"
	"		return -code error \"no header found\"\n"
	"	    }\n"
	"	    set len 540 ; # after 1st iteration we force overlap with last buffer\n"
	"	    incr at 512 ; # to ensure that the pattern we look for is not split at\n"
	"	    #           ; # a buffer boundary, nor the header itself\n"
	"	} else {\n"
	"	    break\n"
	"	}\n"
	"    }\n"
	"\n"
	"    set hdr [string range $hdr [expr $pos + 4] [expr $pos + 21]]\n"
	"    set pos [expr [tell $fd] + $pos - 512]\n"
	"\n"
	"    binary scan $hdr ssssiis \\\n"
	"	cb(ndisk) cb(cdisk) \\\n"
	"	cb(nitems) cb(ntotal) \\\n"
	"	cb(csize) cb(coff) \\\n"
	"	cb(comment)\n"
	"\n"
	"    set cb(ndisk)	[u_short $cb(ndisk)]\n"
	"    set cb(nitems)	[u_short $cb(nitems)]\n"
	"    set cb(ntotal)	[u_short $cb(ntotal)]\n"
	"    set cb(comment)	[u_short $cb(comment)]\n"
	"\n"
	"    # Compute base for situations where ZIP file\n"
	"    # has been appended to another media (e.g. EXE)\n"
	"    set cb(base)	[expr { $pos - $cb(csize) - $cb(coff) }]\n"
	"}\n"
	"\n"
	"proc zip::TOC {fd arr} {\n"
	"    upvar #0 zip::$fd cb\n"
	"    upvar 1 $arr sb\n"
	"\n"
	"    set buf [read $fd 46]\n"
	"\n"
	"    binary scan $buf A4ssssssiiisssssii hdr \\\n"
	"      sb(vem) sb(ver) sb(flags) sb(method) time date \\\n"
	"      sb(crc) sb(csize) sb(size) \\\n"
	"      flen elen clen sb(disk) sb(attr) \\\n"
	"      sb(atx) sb(ino)\n"
	"\n"
	"    set sb(ino) [expr {$cb(base) + $sb(ino)}]\n"
	"\n"
	"    if { ![string equal \"PK\\01\\02\" $hdr] } {\n"
	"	binary scan $hdr H* x\n"
	"	error \"bad central header: $x\"\n"
	"    }\n"
	"\n"
	"    foreach v {vem ver flags method disk attr} {\n"
	"	set cb($v) [u_short [set sb($v)]]\n"
	"    }\n"
	"\n"
	"    set sb(mtime) [DosTime $date $time]\n"
	"    set sb(mode) [expr { ($sb(atx) >> 16) & 0xffff }]\n"
	"    if { ( $sb(atx) & 0xff ) & 16 } {\n"
	"	set sb(type) directory\n"
	"    } else {\n"
	"	set sb(type) file\n"
	"    }\n"
	"    set sb(name) [read $fd [u_short $flen]]\n"
	"    set sb(extra) [read $fd [u_short $elen]]\n"
	"    set sb(comment) [read $fd [u_short $clen]]\n"
	"}\n"
	"\n"
	"proc zip::open {path} {\n"
	"    set fd [::open $path]\n"
	"    \n"
	"    if {[catch {\n"
	"	upvar #0 zip::$fd cb\n"
	"	upvar #0 zip::$fd.toc toc\n"
	"\n"
	"	fconfigure $fd -translation binary ;#-buffering none\n"
	"	\n"
	"	zip::EndOfArchive $fd cb\n"
	"\n"
	"	seek $fd [expr {$cb(base) + $cb(coff)}] start\n"
	"\n"
	"	set toc(_) 0; unset toc(_); #MakeArray\n"
	"	\n"
	"	for { set i 0 } { $i < $cb(nitems) } { incr i } {\n"
	"	    zip::TOC $fd sb\n"
	"	    \n"
	"	    set sb(depth) [llength [file split $sb(name)]]\n"
	"	    \n"
	"	    set name [string tolower $sb(name)]\n"
	"	    set toc($name) [array get sb]\n"
	"	    FAKEDIR toc [file dirname $name]\n"
	"	}\n"
	"    } err]} {\n"
	"	close $fd\n"
	"	return -code error $err\n"
	"    }\n"
	"\n"
	"    return $fd\n"
	"}\n"
	"\n"
	"proc zip::FAKEDIR {arr path} {\n"
	"    upvar 1 $arr toc\n"
	"\n"
	"    if { $path == \".\"} { return }\n"
	"\n"
	"\n"
	"    if { ![info exists toc($path)] } {\n"
	"	# Implicit directory\n"
	"	lappend toc($path) \\\n"
	"		name $path \\\n"
	"		type directory mtime 0 size 0 mode 0777 \\\n"
	"		ino -1 depth [llength [file split $path]]\n"
	"    }\n"
	"    FAKEDIR toc [file dirname $path]\n"
	"}\n"
	"\n"
	"proc zip::exists {fd path} {\n"
	"    #::vfs::log \"$fd $path\"\n"
	"    if {$path == \"\"} {\n"
	"	return 1\n"
	"    } else {\n"
	"	upvar #0 zip::$fd.toc toc\n"
	"	info exists toc([string tolower $path])\n"
	"    }\n"
	"}\n"
	"\n"
	"proc zip::stat {fd path arr} {\n"
	"    upvar #0 zip::$fd.toc toc\n"
	"    upvar 1 $arr sb\n"
	"\n"
	"    set name [string tolower $path]\n"
	"    if { $name == \"\" || $name == \".\" } {\n"
	"	array set sb {\n"
	"	    type directory mtime 0 size 0 mode 0777 \n"
	"	    ino -1 depth 0 name \"\"\n"
	"	}\n"
	"    } elseif {![info exists toc($name)] } {\n"
	"	return -code error \"could not read \\\"$path\\\": no such file or directory\"\n"
	"    } else {\n"
	"	array set sb $toc($name)\n"
	"    }\n"
	"    set sb(dev) -1\n"
	"    set sb(uid)	-1\n"
	"    set sb(gid)	-1\n"
	"    set sb(nlink) 1\n"
	"    set sb(atime) $sb(mtime)\n"
	"    set sb(ctime) $sb(mtime)\n"
	"    return \"\"\n"
	"}\n"
	"\n"
	"# Treats empty pattern as asking for a particular file only\n"
	"proc zip::getdir {fd path {pat *}} {\n"
	"    #::vfs::log [list getdir $fd $path $pat]\n"
	"    upvar #0 zip::$fd.toc toc\n"
	"\n"
	"    if { $path == \".\" || $path == \"\" } {\n"
	"	set path [string tolower $pat]\n"
	"    } else {\n"
	"	set path [string tolower $path]\n"
	"	if {$pat != \"\"} {\n"
	"	    append path /[string tolower $pat]\n"
	"	}\n"
	"    }\n"
	"    set depth [llength [file split $path]]\n"
	"\n"
	"    #puts stderr \"getdir $fd $path $depth $pat [array names toc $path]\"\n"
	"    if {$depth} {\n"
	"	set ret {}\n"
	"	foreach key [array names toc $path] {\n"
	"	    if {[string index $key end] == \"/\"} {\n"
	"		# Directories are listed twice: both with and without\n"
	"		# the trailing '/', so we ignore the one with\n"
	"		continue\n"
	"	    }\n"
	"	    array set sb $toc($key)\n"
	"\n"
	"	    if { $sb(depth) == $depth } {\n"
	"		if {[info exists toc(${key}/)]} {\n"
	"		    array set sb $toc(${key}/)\n"
	"		}\n"
	"		lappend ret [file tail $sb(name)]\n"
	"	    } else {\n"
	"		#::vfs::log \"$sb(depth) vs $depth for $sb(name)\"\n"
	"	    }\n"
	"	    unset sb\n"
	"	}\n"
	"	return $ret\n"
	"    } else {\n"
	"	# just the 'root' of the zip archive.  This obviously exists and\n"
	"	# is a directory.\n"
	"	return [list {}]\n"
	"    }\n"
	"}\n"
	"\n"
	"proc zip::_close {fd} {\n"
	"    variable $fd\n"
	"    variable $fd.toc\n"
	"    unset $fd\n"
	"    unset $fd.toc\n"
	"    ::close $fd\n"
	"}\n"
	"\n"
	"# use zlib to define zip and crc if available\n"
	"if {[llength [info command vfs::zip]] == 0 && [llength [info command zlib]] || ![catch {load \"\" zlib}]} {\n"
	"	proc vfs::zip {flag value args} {\n"
	"		switch -glob -- \"$flag $value\" {\n"
	"			{-mode d*} { set mode decompress }\n"
	"			{-mode c*} { set mode compress }\n"
	"			default { error \"usage: zip -mode {compress|decompress} data\" }\n"
	"		}\n"
	"\n"
	"		# kludge to allow \"-nowrap 1\" as second option, 5-9-2002\n"
	"		if {[llength $args] > 2 && [lrange $args 0 1] eq \"-nowrap 1\"} {\n"
	"			if {$mode eq \"compress\"} {\n"
	"				set mode deflate\n"
	"			} else {\n"
	"				set mode inflate\n"
	"			}\n"
	"		}\n"
	"\n"
	"		return [zlib $mode [lindex $args end]]\n"
	"	}\n"
	"}\n"
