	"proc tclInit {} {\n"
	"	rename tclInit {}\n"
	"\n"
	"	global auto_path tcl_library tcl_libPath\n"
	"	global tcl_version tcl_rcFileName\n"
	"  \n"
	"	set noe [info nameofexecutable]\n"
	"\n"
	"	# Resolve symlinks\n"
	"	set noe [file dirname [file normalize [file join $noe __dummy__]]]\n"
	"\n"
	"	set tcl_library [file join $noe lib tcl$tcl_version]\n"
	"	set tcl_libPath [list $tcl_library [file join $noe lib]]\n"
	"\n"
	"	# get rid of a build residue\n"
	"	unset -nocomplain ::tclDefaultLibrary\n"
	"\n"
	"	# the following code only gets executed once on startup\n"
	"	if {[info exists tcl_rcFileName]} {\n"
	"		# lookup and emulate \"source\" of lib/vfs/{vfs*.tcl,mk4vfs.tcl}\n"
	"		switch -- $::tclKitStorage {\n"
	"			\"mk4\" {\n"
	"				load {} vfs\n"
	"\n"
	"				# must use raw MetaKit calls because VFS is not yet in place\n"
	"				set d [mk::select exe.dirs parent 0 name lib]\n"
	"				set d [mk::select exe.dirs parent $d name vfs]\n"
	"    \n"
	"				foreach x {vfsUtils vfslib mk4vfs} {\n"
	"					set n [mk::select exe.dirs!$d.files name $x.tcl]\n"
	"					set s [mk::get exe.dirs!$d.files!$n contents]\n"
	"					catch {set s [zlib decompress $s]}\n"
	"					uplevel #0 $s\n"
	"				}\n"
	"\n"
	"				# use on-the-fly decompression, if mk4vfs understands that\n"
	"				set mk4vfs::zstreamed 1\n"
	"\n"
	"				# Set VFS handler name\n"
	"				set vfsHandler [list ::vfs::mk4::handler exe]\n"
	"			}\n"
	"			\"zip\" {\n"
	"				set prefix \"lib/vfs\"\n"
	"				foreach file [list vfsUtils vfslib] {\n"
	"					set fullfile \"${prefix}/${file}.tcl\"\n"
	"\n"
	"					::zip::stat $::tclKitStorage_fd $fullfile finfo\n"
	"					seek $::tclKitStorage_fd $finfo(ino)\n"
	"					zip::Data $::tclKitStorage_fd sb s\n"
	"\n"
	"					switch -- $file {\n"
	"						\"vfsUtils\" {\n"
	"							# Preserve our working \"::vfs::zip\" implementation\n"
	"							# so we can replace it after the stub is replaced\n"
	"							# from vfsUtils\n"
	"							# The correct implementation will be provided by vfslib, \n"
	"							# but only if we can read it\n"
	"							rename ::vfs::zip ::vfs::zip_impl\n"
	"						}\n"
	"					}\n"
	"\n"
	"					uplevel #0 $s\n"
	"\n"
	"					switch -- $file {\n"
	"						\"vfsUtils\" {\n"
	"							# Restore preserved \"::vfs:zip\" implementation\n"
	"							rename ::vfs::zip {}\n"
	"							rename ::vfs::zip_impl ::vfs::zip\n"
	"						}\n"
	"					}\n"
	"				}\n"
	"\n"
	"				seek $::tclKitStorage_fd 0\n"
	"				set vfsHandler [list ::vfs::zip::handler $::tclKitStorage_fd]\n"
	"				unset ::tclKitStorage_fd\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# mount the executable, i.e. make all runtime files available\n"
	"		vfs::filesystem mount $noe $vfsHandler\n"
	"\n"
	"		# alter path to find encodings\n"
	"		if {[info tclversion] eq \"8.4\"} {\n"
	"			load {} pwb\n"
	"			librarypath [info library]\n"
	"		} else {\n"
	"			encoding dirs [list [file join [info library] encoding]] ;# TIP 258\n"
	"		}\n"
	"\n"
	"		# fix system encoding, if it wasn't properly set up (200207.004 bug)\n"
	"		if {[encoding system] eq \"identity\"} {\n"
	"			if {[info exists ::tclkit_system_encoding] && $::tclkit_system_encoding != \"\"} {\n"
	"				catch {\n"
	"					encoding system $::tclkit_system_encoding\n"
	"				}\n"
	"			}\n"
	"			unset -nocomplain ::tclkit_system_encoding\n"
	"		}\n"
	"\n"
	"		# If we've still not been able to set the encoding, revert to Tclkit defaults\n"
	"		if {[encoding system] eq \"identity\"} {\n"
	"			catch {\n"
	"				switch $::tcl_platform(platform) {\n"
	"					windows		{ encoding system cp1252 }\n"
	"					macintosh	{ encoding system macRoman }\n"
	"				        default		{ encoding system iso8859-1 }\n"
	"				}\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# now remount the executable with the correct encoding\n"
	"		vfs::filesystem unmount [lindex [::vfs::filesystem info] 0]\n"
	"\n"
	"		set noe [info nameofexecutable]\n"
	"\n"
	"		# Resolve symlinks\n"
	"		set noe [file dirname [file normalize [file join $noe __dummy__]]]\n"
	"\n"
	"		set tcl_library [file join $noe lib tcl$tcl_version]\n"
	"		set tcl_libPath [list $tcl_library [file join $noe lib]]\n"
	"\n"
	"		vfs::filesystem mount $noe $vfsHandler\n"
	"	}\n"
	"  \n"
	"	# load config settings file if present\n"
	"	namespace eval ::vfs { variable tclkit_version 1 }\n"
	"	catch { uplevel #0 [list source [file join $noe config.tcl]] }\n"
	"\n"
	"	uplevel #0 [list source [file join $tcl_library init.tcl]]\n"
	"  \n"
	"	# reset auto_path, so that init.tcl's search outside of tclkit is cancelled\n"
	"	set auto_path $tcl_libPath\n"
	"\n"
	"	# This loads everything needed for \"clock scan\" to work\n"
	"	# \"clock scan\" is used within \"vfs::zip\", which may be\n"
	"	# loaded before this is run causing the root VFS to break\n"
	"	catch { clock scan }\n"
	"\n"
	"	# Cleanup\n"
	"	unset ::tclKitStorage\n"
	"	unset -nocomplain ::tclKitStorage_fd\n"
	"}\n"
