/*
	Created for Netfuel Design (http://www.netfueldesign.com/) 
	To do user management and billing.

	-- Roy Keene [0200220002117] rkeene@netfueldesign.com
*/

#include "encrypt.h"
#include "screenio.h"
#include "billing.h"
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <signal.h>
#include <ctype.h>

int tty_fd=1, old_clflags;


void resetdisplay(int signal) {
        struct termios terminfo;
        tcgetattr(tty_fd, &terminfo);
        terminfo.c_lflag=old_clflags;
        tcsetattr(tty_fd, TCSADRAIN, &terminfo);
}


int main(int argc, char **argv) {
	struct termios terminfo;
	int selected=0, oselected=-1;
	char ch;
	static struct menulist menu[10];
	if ( signal(SIGTERM, (void *) resetdisplay)==SIG_ERR || \
		signal(SIGINT, (void *) resetdisplay)==SIG_ERR) {
		perror("main: signal");
		printf("Something might happen to your display.\n");
	}
	clear();
	tty_fd=open("/dev/tty", O_RDWR);
	ioctl(tty_fd, TCGETS, &terminfo);
	old_clflags=terminfo.c_lflag;
	terminfo.c_lflag=0;
	ioctl(tty_fd, TCSETS, &terminfo);


	playmenu("main.mnu");
        resetdisplay(-1);
        close(tty_fd);
	return(0);

/* This stuff is Old, left so I can look at it.  Moo. */
	menu[0].hotkey='N';
	strcpy(menu[0].name,"New user");
	menu[1].hotkey='Q';
	strcpy(menu[1].name,"Quit");


	drawmenu("Main Menu", menu, 2, selected);
	while(1) {
		read(STDIN_FILENO, &ch, 1);
		if (ch==66) selected++;
		if (ch==65) selected--;
		if (selected<0) selected=0;
		if (selected>1) selected=1;
		if (ch==13 || ch==10) ch=tolower(menu[selected].hotkey);
		switch (ch) {
			case 'q':
				clear();
				resetdisplay(-1);
				return(0);
				break;
			case 'n':
				
				selected=0;
				
				break;
		}
		if (oselected!=selected) {
			gohome();
			drawmenu("Main Menu", menu, 2, selected);
			oselected=selected;
		}


	}
		
	resetdisplay(-1);
	close(tty_fd);
	return(0);
}

int drawmenu(char *title, struct menulist menuitems[], int numitems, int selected) {
	int i;
	printf("%40s\n\n", title);
	for (i=0; i<numitems; i++) {
		printf("\033[%im%c - %-50s\033[0m\n", (i==selected)*7, menuitems[i].hotkey, menuitems[i].name);
	}
	return(0);
}

/*
	Menu file format:
	[title (TITLE_LEN bytes)]([menu (sizeof struct menulist)]*)
*/
int playmenu(char *file) {
	struct menulist menuitems[10];
	struct stat finfo;
	char title[TITLE_LEN];
	char ch;
	int selected=0, oselected=0, fd, item_cnt=0, i;
	fd=open(file, O_RDONLY);
	fstat(fd, &finfo);
	if (finfo.st_size<TITLE_LEN) {
		item_cnt=0;
	} else {
		item_cnt=(int) ((finfo.st_size-TITLE_LEN)/sizeof(struct menulist));
	}
	read(fd, &title, TITLE_LEN);
	for (i=0;i<item_cnt;i++) {
		read(fd, &menuitems[i], sizeof(struct menulist));
	}
	close(fd);
	clear();
	drawmenu(title, menuitems, item_cnt, selected);
	while(1) {
		read(STDIN_FILENO, &ch, 1);
		if (ch==65) selected--;
		if (ch==66) selected++;
		if (ch==3) return(0);
		if (selected<0) selected=0;
		if (selected>(item_cnt-1)) selected=(item_cnt-1);
		if (ch==13 || ch==10) ch=tolower(menuitems[selected].hotkey);
		ch=tolower(ch);
		for (i=0;i<item_cnt;i++) {
			if (ch==tolower(menuitems[i].hotkey)) {
#ifdef DEBUG
				printf("%i -- %s\n", menuitems[i].exec_cmd.type, menuitems[i].exec_cmd.exec_file);
#endif
				switch (menuitems[i].exec_cmd.type) {
					case BILLING_EXEC_MENU:
						playmenu(menuitems[i].exec_cmd.exec_file);
						clear();
						oselected=-1;
						break;
					case BILLING_EXEC_TCL:
						break;
					case BILLING_EXEC_QUIT:
						return(0);
						break;
					case BILLING_EXEC_INPT:
						
						break;
				}
			}
		}

		if (selected!=oselected) {
			gohome();
			drawmenu(title, menuitems, item_cnt, selected);
			oselected=selected;
		}

	}
}
