/*
	Download a file slowly!

		-- Roy Keene <rkeene@rkeene.org>
*/


#include <sys/types.h>
#include <sys/stat.h>
#include <opennet.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include "slowdl.h"

extern char *optarg;
extern int optind, opterr, optopt;


char *last_element(char *str, char sep) {
	static char retbuf[1024];
	strncpy(retbuf, strrchr(str,sep)+1, sizeof(retbuf)-1);
	return(retbuf);
}

int main(int argc, char **argv) {
	char *buf;
	char opt_quiet=0;
	int i,x,fd,ofd,blksize=0,nblksize=SLOWDL_DEF_BUFFSIZE,delay,ch=0;
	int flags;

	while ((i=getopt(argc,argv,"q")) != -1) {
		switch (i) {
			case 'q':
				opt_quiet=!opt_quiet;
				break;
			case '?':
			case ':':
				fprintf(stderr, "Exiting.\n");
				return(1);
				break;
		}
	}

	blksize=nblksize;
	buf=malloc(blksize);
	delay=300000;

	if (!opt_quiet) {
		fprintf(stderr, "Using speed of %5.3f bytes/sec\n",((float) blksize )/(((float) delay)/1000000 ) );
		flags=fcntl(STDIN_FILENO, F_GETFL);
		fcntl(STDIN_FILENO, F_SETFL, flags|O_NONBLOCK|O_SYNC);
	}

	for (i=optind;i<argc;i++) {
		if ((fd=open_net(argv[i], O_RDONLY)) <0) {
			fprintf(stderr, __APPNAME ": %s: ",argv[i]);
			perror("");
			continue;
		}
		if ((ofd=open_net(last_element(argv[i],'/'), O_WRONLY|O_CREAT|O_TRUNC, 0666)) <0) {
			perror("open");
			close(fd);
			continue;
		}
		


		while ((x=read_net(fd,buf,blksize))>0) {
			write(ofd,buf,x);
			usleep(delay);

			do {
				ch=0;
				read(STDIN_FILENO, &ch, 1);
				switch (ch) {
					case '+': nblksize+=5; break;
					case '-': nblksize-=5; break;
				}
			} while (ch!=0);

			if (nblksize>1024) nblksize=1024;
			if (nblksize<1) nblksize=1;

			if (blksize!=nblksize) {
				blksize=nblksize;
				delay=(int) (((float) 300000)-((((float) blksize)-1)*293.25513196));
				if (!opt_quiet) {
					fprintf(stderr, "Using speed of %5.3f bytes/sec\n",((float) blksize )/(((float) delay)/1000000 ) );
				}
				buf=realloc(buf,nblksize);
			}
		}
		close(fd);
	}
	return(0);
}
