#! /usr/bin/env tclsh

set teapotservers [list teapot.activestate.com teapot.rkeene.org]

lappend auto_path [file join [file dirname [info script]] lib]

package require teapotclient

proc print_help {} {
	puts stderr "Usage: teapot-client get <dir> <os> <cpu> <packages...>"
	puts stderr "Usage: teapot-client list ?<os> ?<cpu>??"
}

set cmd [lindex $argv 0]
set argv [lrange $argv 1 end]

switch -- $cmd {
	"get" {
		if {[llength $argv] < 4} {
			print_help
			exit 1
		}

		set existingexts [list]

		set dir [lindex $argv 0]
		set os [lindex $argv 1]
		set cpu [lindex $argv 2]
		set packages [lrange $argv 3 end]

		set newpackages [list]
		foreach package $packages {
			if {[string index $package 0] == "!"} {
				lappend existingexts [string range $package 1 end]
			} else {
				lappend newpackages $package
			}
		}
		set packages $newpackages

		set extsinfo [::teapotclient::download_extensions [file join $dir lib] $teapotservers $packages $os $cpu $existingexts]
		set exts [list]
		puts "Fetched Extensions:"
		foreach {ext extinfo} $extsinfo {
			lappend exts $ext
			puts "  $ext v[lindex $extinfo 0]"
		}

		set failedexts [list]
		foreach pkg $packages {
			if {[lsearch -exact $exts $pkg] == -1} {
				lappend failedexts $pkg
			}
		}
		if {[llength $failedexts] != 0} {
			puts "Failed to fetch:"
			foreach ext $failedexts {
				puts "  $ext"
			}
			exit 1
		}
	}
	"list" {
		if {$tcl_platform(platform) == "unix"} {
			set os [string tolower $tcl_platform(os)]
		} else {
			set os [string tolower $tcl_platform(platform)]
		}
		set cpu [string tolower $tcl_platform(machine)]
		if {[llength $argv] > 0} {
			set os [lindex $argv 0]
		}
		if {[llength $argv] > 1} {
			set cpu [lindex $argv 1]
		}

		puts "Extensions available for OS=$os, CPU=$cpu:"

		foreach teapotserver $teapotservers {
			array set exts [::teapotclient::get_extensions $teapotserver $os $cpu]
		}

		foreach ext [lsort -dictionary [array names exts]] {
			set extinfo $exts($ext)

			set extvers [list]
			foreach extinfoitem $extinfo {
				set extinfoitemvers [lindex $extinfoitem 0]
				if {[lsearch -exact $extvers $extinfoitemvers] == -1} {
					lappend extvers $extinfoitemvers
				}
			}
			set extvers [lsort -decreasing -dictionary $extvers]

			puts "  $ext [lindex $extvers 0]"
		}
	}
	default {
		print_help
		exit 1
	}
}
