#! /bin/bash

if [ ! -x "../platform" ]; then
	echo "No platform script found, aborting." >&2

	exit 1
fi

VERS=8.5.2
SRC="src/tclDict-${VERS}.tar.gz"
SRCURL="http://pascal.scheffers.net/software/tclDict-${VERS}.tar.gz"
BUILDDIR="tclDict-${VERS}"
WORKDIR="${TMPDIR:-/tmp}/dict-$$${RANDOM}${RANDOM}${RANDOM}"
PLATFORM="$(../platform)"
PLATDIR="$(pwd)/out/${PLATFORM}"

export VERS SRC SRCURL BUILDDIR WORKDIR PLATFORM PLATDIR

if [ ! -f "${SRC}" ]; then
	mkdir src >/dev/null 2>/dev/null

	wget -O "${SRC}" "${SRCURL}" || exit 1
fi

(
	rm -rf build out
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	# This fixes a well-known, long-standing failure in many Tcl
	# configure scripts
	sed "s@ /etc/\\.relid'@ '/etc/.relid'@" configure > configure.new
	cat configure.new > configure
	rm -f configure.new

	./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}"

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "dict" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "Dict Backports for Tcl 8.4"

exit 0
