#! /bin/bash

if [ ! -x "../platform" ]; then
	echo "No platform script found, aborting." >&2

	exit 1
fi

if [ "${PLATFORM}" = "tcl" ]; then
	rm -rf out

	exit 0
fi

VERS=3.6.22
VERSUNDER="$(echo "${VERS}" | sed 's@\.@_@g')"
SRC="src/sqlite-${VERSUNDER}.tar.gz"
SRCURL="http://www.sqlite.org/sqlite-${VERSUNDER}-tea.tar.gz"
BUILDDIR="sqlite-${VERSUNDER}-tea"
WORKDIR="${TMPDIR:-/tmp}/sqlite-$$${RANDOM}${RANDOM}${RANDOM}"
PLATDIR="$(pwd)/out/${PLATFORM}"

export VERS SRC SRCURL BUILDDIR WORKDIR PLATDIR

if [ ! -f "${SRC}" ]; then
	mkdir src >/dev/null 2>/dev/null

	wget -O "${SRC}" "${SRCURL}" || exit 1
fi

(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	chmod +x tclconfig/install-sh

	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "sqlite3" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "SQLite"

exit 0
