	"#! /usr/bin/env tclsh\n"
	"\n"
	"namespace eval ::tuapi {}\n"
	"namespace eval ::tuapi::helper {}\n"
	"\n"
	"set ::tuapi::_mount_flags(bind) BIND\n"
	"set ::tuapi::_mount_flags(move) MOVE\n"
	"set ::tuapi::_mount_flags(remount) REMOUNT\n"
	"set ::tuapi::_mount_flags(mandlock) MANDLOCK\n"
	"set ::tuapi::_mount_flags(dirsync) DIRSYNC\n"
	"set ::tuapi::_mount_flags(noatime) NOATIME\n"
	"set ::tuapi::_mount_flags(nodiratime) NODIRATIME\n"
	"set ::tuapi::_mount_flags(relatime) RELATIME\n"
	"set ::tuapi::_mount_flags(strictatime) STRICTATIME\n"
	"set ::tuapi::_mount_flags(nodev) NODEV\n"
	"set ::tuapi::_mount_flags(noexec) NOEXEC\n"
	"set ::tuapi::_mount_flags(nosuid) NOSUID\n"
	"set ::tuapi::_mount_flags(ro) RDONLY\n"
	"set ::tuapi::_mount_flags(silent) SILENT\n"
	"set ::tuapi::_mount_flags(synchronous) SYNCHRONOUS\n"
	"set ::tuapi::_mount_flags(sync) SYNCHRONOUS\n"
	"\n"
	"\n"
	"# Determine where to mount a given device (usually by checking \"/etc/fstab\")\n"
	"proc ::tuapi::helper::find_mountpoint {device} {\n"
	"	set data \"\"\n"
	"	catch {\n"
	"		set fd [open \"/etc/fstab\"]\n"
	"		set data [read -nonewline $fd]\n"
	"		close $fd\n"
	"	}\n"
	"\n"
	"	foreach line [split $data \"\\n\"] {\n"
	"		set line [string trim [regsub {#.*$} $line \"\"]]\n"
	"		set line [regsub -all {[ \\t][ \\t][ \\t]*} $line \" \"]\n"
	"\n"
	"		set work [split $line]\n"
	"\n"
	"		set curr_device     [lindex $work 0]\n"
	"		set curr_mountpoint [lindex $work 1]\n"
	"		set curr_fstype     [lindex $work 2]\n"
	"		set curr_opts       [split [lindex $work 3] \",\"]\n"
	"		set curr_dumpfreq   [lindex $work 4]\n"
	"		set curr_fsckpass   [lindex $work 5]\n"
	"\n"
	"\n"
	"		if {$curr_device == $device || $curr_mountpoint == $device} {\n"
	"			return [list source $curr_device target $curr_mountpoint fstype $curr_fstype options $curr_opts dumpfreq $curr_dumpfreq fsckpass $curr_fsckpass]\n"
	"		}\n"
	"	}\n"
	"\n"
	"	return -code error \"no entry found in \\\"/etc/fstab\\\" for \\\"$device\\\"\"\n"
	"}\n"
	"\n"
	"proc ::tuapi::mount args {\n"
	"	set options_list [list]\n"
	"\n"
	"	for {set idx 0} {$idx < [llength $args]} {incr idx} {\n"
	"		set curr_arg [lindex $args $idx]\n"
	"\n"
	"		switch -glob -- $curr_arg {\n"
	"			\"-t\" {\n"
	"				incr idx\n"
	"				set fstype [lindex $args $idx]\n"
	"			}\n"
	"			\"-r\" {\n"
	"				lappend options_list \"RDONLY\"\n"
	"			}\n"
	"			\"-w\" {\n"
	"				set idx [lsearch -exact $options_list \"RDONLY\"]\n"
	"				if {$idx != -1} {\n"
	"					set options_list [lreplace $options_list $idx $idx]\n"
	"				}\n"
	"			}\n"
	"			\"-o\" {\n"
	"				incr idx\n"
	"				set options [lindex $args $idx]\n"
	"			}\n"
	"			\"--\" {\n"
	"				incr idx\n"
	"\n"
	"				break\n"
	"			}\n"
	"			\"-*\" {\n"
	"				return -code error \"unknown option \\\"$curr_arg\\\"\"\n"
	"			}\n"
	"			default {\n"
	"				break\n"
	"			}\n"
	"		}\n"
	"	}\n"
	"\n"
	"	set args [lrange $args $idx end]\n"
	"\n"
	"	if {[llength $args] < 1 || [llength $args] > 2} {\n"
	"		return -code error \"wrong # args: should be \\\"::tuapi::mount ?options? source ?target?\\\"\"\n"
	"	}\n"
	"\n"
	"	set source [lindex $args 0]\n"
	"\n"
	"	if {[llength $args] == 2} {\n"
	"		set target [lindex $args 1]\n"
	"	} else {\n"
	"		array set mountinfo [::tuapi::helper::find_mountpoint $source]\n"
	"		set source $mountinfo(source)\n"
	"		set target $mountinfo(target)\n"
	"\n"
	"		if {![info exists fstype]} {\n"
	"			set fstype $mountinfo(fstype)\n"
	"		}\n"
	"\n"
	"		if {![info exists options]} {\n"
	"			set options $mountinfo(options)\n"
	"		}\n"
	"	}\n"
	"\n"
	"	# Ensure all mount-related parameters have been computed\n"
	"	if {![info exists fstype]} {\n"
	"		set fstype \"auto\"\n"
	"	}\n"
	"\n"
	"	if {![info exists options]} {\n"
	"		set options [list]\n"
	"	}\n"
	"\n"
	"	# Process options\n"
	"	foreach option $options {\n"
	"		set option_lc [string tolower $option]\n"
	"\n"
	"		# Special option handling\n"
	"		switch -- $option_lc {\n"
	"			\"defaults\" {\n"
	"				set options_list [list]\n"
	"				unset -nocomplain unknown_options\n"
	"\n"
	"				continue\n"
	"			}\n"
	"			\"rw\" {\n"
	"				set option_lc \"noro\"\n"
	"			}\n"
	"			\"norw\" {\n"
	"				set option_lc \"ro\"\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# Example: noatime\n"
	"		if {[info exists ::tuapi::_mount_flags($option_lc)]} {\n"
	"			lappend options_list $::tuapi::_mount_flags($option_lc)\n"
	"\n"
	"			continue\n"
	"		}\n"
	"\n"
	"		# Example: atime\n"
	"		if {[info exists ::tuapi::_mount_flags(no$option_lc)]} {\n"
	"			set idx [lsearch -exact $options_list $::tuapi::_mount_flags(no$option_lc)]\n"
	"			if {$idx != -1} {\n"
	"				set options_list [lreplace $options_list $idx $idx]\n"
	"			}\n"
	"\n"
	"			continue\n"
	"		}\n"
	"\n"
	"		# Example: norelatime\n"
	"		if {[string match \"no*\" $option_lc]} {\n"
	"			set neg_option_lc [string range $option_lc 2 end]\n"
	"\n"
	"			if {[info exists ::tuapi::_mount_flags($neg_option_lc)]} {\n"
	"				set idx [lsearch -exact $options_list $::tuapi::_mount_flags($neg_option_lc)]\n"
	"				if {$idx != -1} {\n"
	"					set options_list [lreplace $options_list $idx $idx]\n"
	"				}\n"
	"\n"
	"				continue\n"
	"			}\n"
	"		}\n"
	"\n"
	"		# Accumulate unknown options\n"
	"		lappend unknown_options $option\n"
	"	}\n"
	"\n"
	"	# Use \"swapon\" if this is swap\n"
	"	if {$fstype == \"swap\"} {\n"
	"		return [::tuapi::syscall::swapon $source]\n"
	"	}\n"
	"\n"
	"	# Otherwise, call \"mount\" system call\n"
	"	## If we have accumulated any unknown options, pass them as a\n"
	"	## comma-seperated value string\n"
	"	if {[info exists unknown_options]} {\n"
	"		set data [join $unknown_options \",\"]\n"
	"\n"
	"		return [::tuapi::syscall::mount $source $target $fstype $options_list $data]\n"
	"	}\n"
	"\n"
	"	return [::tuapi::syscall::mount $source $target $fstype $options_list]\n"
	"}\n"
	"\n"
	"proc ::tuapi::umount {dir {flags \"\"}} {\n"
	"	return [::tuapi::syscall::umount $dir [string toupper $flags]]\n"
	"}\n"
	"\n"
	"proc ::tuapi::kill {pid sig} {\n"
	"	return [::tuapi::syscall::kill $pid [string toupper $sig]]\n"
	"}\n"
	"\n"
	"proc ::tuapi::killpg {pgroup sig} {\n"
	"	if {$pgroup <= 1} {\n"
	"		return -code error \"invalid process group specified (must be greater than 1)\"\n"
	"	}\n"
	"\n"
	"	return [::tuapi::syscall::kill -$pgroup [string toupper $sig]]\n"
	"}\n"
	"\n"
	"proc ::tuapi::ifconfig args {\n"
	"	if {[llength $args] == 0} {\n"
	"		# Return information on all interfaces\n"
	"		set retlist [list]\n"
	"		foreach interface [::tuapi::syscall::ifconfig] {\n"
	"			lappend retlist $interface [::tuapi::syscall::ifconfig $interface]\n"
	"		}\n"
	"\n"
	"		return $retlist\n"
	"	}\n"
	"\n"
	"	set interface [lindex $args 0]\n"
	"	set args [lrange $args 1 end]\n"
	"\n"
	"	array set ifaceinfo [::tuapi::syscall::ifconfig $interface]\n"
	"\n"
	"	if {[llength $args] == 0} {\n"
	"		return [array get ifaceinfo]\n"
	"	}\n"
	"\n"
	"	for {set idx 0} {$idx < [llength $args]} {incr idx} {\n"
	"		set opt [lindex $args $idx]\n"
	"\n"
	"		switch -- $opt {\n"
	"			\"up\" {\n"
	"				if {[info exists ifaceinfo(flags)]} {\n"
	"					set flags $ifaceinfo(flags)\n"
	"				} else {\n"
	"					set flags \"\"\n"
	"				}\n"
	"\n"
	"				foreach newflag [list UP RUNNING] {\n"
	"					if {[lsearch -exact $flags $newflag] == -1} {\n"
	"						lappend flags $newflag\n"
	"					}\n"
	"				}\n"
	"\n"
	"				::tuapi::syscall::ifconfig $interface flags $flags\n"
	"			}\n"
	"\n"
	"		}\n"
	"	}\n"
	"}\n"
