/* Roy Keene
   CS 2314
   Section 04
   Lab 04
   17 Sept 02
   queue.h

   Fully tested configurations:
        *MSVC++       6.0    i386    Windows XP
        Sun Workshop 6.0    sun4u   Solaris
        Intel        6.0    i386    Linux
        g++          3.0.3  sun4u   Solaris
        g++          3.0.2  ip27    IRIX
        g++          2.95.4 i386    FreeBSD
        g++          2.95.4 alpha   Linux
        g++          2.95.4 sun4u   Linux
        g++          2.95.4 powerpc Linux
        g++          2.95.4 armv4l  Linux
        g++          2.96   i386    Linux
        g++          2.95.3 i386    Linux
        g++          2.95.3 sun4u   Solaris
        c++          2.95.2 powerpc MacOS X
        g++          2.95.2 i386    Linux
        g++          2.8.1  sun4u   Solaris
*/

#include <iostream>
#include <string>

using namespace std;
#include "queue.h"

char Menu(void) {
	string userinput;
	int x;

	while (1) {
		cout << "       MENU\n";
		cout << " number | description\n";
		cout << " 1      | Check out a movie\n";
		cout << " 2      | Return a movie\n";
		cout << " 3      | View movie status\n";
		cout << " 4      | Exit\n";
		cout << "Choice> ";
		cout.flush();
		cin >> userinput;
		x=userinput[0]-'0';
		if (x<1 || x>4) {
			cout << "Invalid choice.\n";
		} else {
			break;
		}
	}
	return(x);
}

int main(void) {
	QueType<string> MovieQueue;
	char MovieName[1024];
	char choice;
	int MovieCount=0, i;

	while (1) {
		choice=Menu();
		switch (choice) {
			case 1:
				cout << "Enter the movie title> ";
				cout.flush();
				cin.ignore();
				cin.getline(MovieName, sizeof(MovieName), '\n');
				MovieQueue.Enqueue(MovieName);
				if (MovieCount<3) {
					cout << "You have checked out \"" << MovieName << "\", it is being sent immediately.\n";
				} else {
					cout << "You already have 3 movies checked out, as soon as one is returned \"" << MovieName << "\", will be sent.\n";
				}
				MovieCount++;
				break;
			case 2:
				if (MovieCount==0) {
					cout << "You have no movies checked out!\n";
					break;
				}
				MovieCount--;
				cout << "You have returned \"" << MovieQueue.Front() << "\"\n";
				MovieQueue.Dequeue();
				break;
			case 3:
				if (MovieCount==0) {
					cout << "You have no movies checked out!\n";
					break;
				}
				MovieQueue.Next(1);
				cout << "Currently checked out movies:\n";
				for (i=0;i<(  (MovieCount<3)?MovieCount:3  );i++) {
					cout << "  \"" << MovieQueue.Next(0) << "\"\n";
				}
				if (MovieCount>3) {
					cout << "Next movie to be sent:\n";
					cout << "  \"" << MovieQueue.Next(0) << "\"\n";
				}
				break;
			case 4:
				return(0);
				break;
		}
	}
	return(0);
}
