/* Roy Keene
   CS 2314
   Section 04
   Lab 05
   08 Oct 02
   lab5.cpp

   Fully tested configurations:
        *MSVC++       6.0    i386    Windows XP
        *Sun Workshop 6.0    sun4u   Solaris
        *Intel        6.0    i386    Linux
        *g++          3.0.3  sun4u   Solaris
        *g++          3.0.2  ip27    IRIX
        *g++          2.95.4 i386    FreeBSD
        *g++          2.95.4 alpha   Linux
        *g++          2.95.4 sun4u   Linux
        *g++          2.95.4 powerpc Linux
        *g++          2.95.4 armv4l  Linux
        *g++          2.96   i386    Linux
        *g++          2.95.3 i386    Linux
        *g++          2.95.3 sun4u   Solaris
        *c++          2.95.2 powerpc MacOS X
        *g++          2.95.2 i386    Linux
        *g++          2.8.1  sun4u   Solaris
*/

#include <iostream>
#include <fstream>
#include <stack>
#include <string>

using namespace std;
#include "poly.h"

int main(void) {
	ifstream ifd;
	stack<Poly *> exp_stack;
	Poly *ret, *o1;
	string oper;
	unsigned char ocd;
	int exp, coeff, n, i;

	ifd.open("poly.dat");
	while (ifd >> oper) {
		ocd=oper[0];
		switch (ocd) {
			case 'p':
				ifd >> n;
				ret=new Poly;
				for (i=0;i<n;i++) {
					ifd >> exp;
					ifd >> coeff;
					ret->insert_term(coeff, exp);
				}
				exp_stack.push(ret);
				break;
			case '*':
				ret=exp_stack.top(); exp_stack.pop();
				o1=exp_stack.top(); exp_stack.pop();
				cout << ret->equ() << " * " << o1->equ();
				ret=o1->Mul(*ret);
				cout << " = " << ret->equ() << "\n";
				exp_stack.push(ret);
				delete o1;
				break;
			case '+':
				ret=exp_stack.top(); exp_stack.pop();
				o1=exp_stack.top(); exp_stack.pop();
				cout << ret->equ() << " + " << o1->equ();
				ret=o1->Add(*ret);
				cout << " = " << ret->equ() << "\n";
				exp_stack.push(ret);
				delete o1;
				break;
			case '-':
				ret=exp_stack.top(); exp_stack.pop();
				o1=exp_stack.top(); exp_stack.pop();
				cout << ret->equ() << " - " << o1->equ();
				ret=o1->Sub(*ret);
				cout << " = " << ret->equ() << "\n";
				exp_stack.push(ret);
				delete o1;
				break;
			case 'e':
				ifd >> n;
				ret=exp_stack.top();
				cout << "At x=" << n << " " << ret->equ() << " = " << ret->Evaluate(n) << "\n";
				break;
			default:
				cerr << "Unknown operator '"  << oper[0] << "'\n";
		}
	}
	ifd.close();

	return(0);
}
