/* Roy Keene
   CS 2314
   Section 04
   Lab 05
   08 Oct 02
   poly.cpp
*/

#include <list>
#include <iterator>
#include <sstream>
#include <string>
#include <cmath>
#include "poly.h"

Poly::Poly(void) { return; }
Poly::~Poly(void) { return; }
void Poly::insert_term(int coeff, int exp) {
	struct PolyTerm *newTerm=new struct PolyTerm;
	list<struct PolyTerm *>::iterator start, stop;
	struct PolyTerm *tmp;

	newTerm->coeff=coeff;
	newTerm->exp=exp;

	start=polyterms.begin();
	stop=polyterms.end();
	while (start!=stop) {
		tmp=*start;
		if (tmp->exp==exp) {
			newTerm->coeff+=tmp->coeff;
			*start++;
			polyterms.remove(tmp);
			break;
/*			continue; */
		}
		start++;
	}
	if (newTerm->coeff==0) { delete newTerm; return; }
	polyterms.push_back(newTerm);
	return;
}

list<struct PolyTerm *> Poly::get_term(void) {
	return(polyterms);
}

Poly *Poly::Mul(Poly b) {
	Poly *ret=new Poly;
	list<struct PolyTerm *> b_lst;
	list<struct PolyTerm *>::iterator astart, astop, bstart, bstop;
	struct PolyTerm *aterm, *bterm;

	b_lst=b.get_term();

	astart=polyterms.begin();
	astop=polyterms.end();
	bstop=b_lst.end();
	while (astart!=astop) {
		aterm=*astart;
		bstart=b_lst.begin();
		while (bstart!=bstop) {
			bterm=*bstart;
			ret->insert_term((bterm->coeff)*(aterm->coeff), (bterm->exp)+(aterm->exp));
			bstart++;
		}
		astart++;
	}

	return(ret);
}

Poly *Poly::Sub(Poly b) {
	Poly *ret=new Poly;
	list<struct PolyTerm *> b_lst;
	list<struct PolyTerm *>::iterator astart, astop, bstart, bstop;
	struct PolyTerm *aterm, *bterm;

	b_lst=b.get_term();

	astart=polyterms.begin();
	astop=polyterms.end();
	bstart=b_lst.begin();
	bstop=b_lst.end();
	while (astart!=astop) {
		aterm=*astart;
		ret->insert_term((aterm->coeff), aterm->exp);
		astart++;
	}
	while (bstart!=bstop) {
		bterm=*bstart;
		ret->insert_term(-(bterm->coeff), bterm->exp);
		bstart++;
	}

	return(ret);
}

Poly *Poly::Add(Poly b) {
	Poly *ret=new Poly;
	list<struct PolyTerm *> b_lst;
	list<struct PolyTerm *>::iterator astart, astop, bstart, bstop;
	struct PolyTerm *aterm, *bterm;

	b_lst=b.get_term();

	astart=polyterms.begin();
	astop=polyterms.end();
	bstart=b_lst.begin();
	bstop=b_lst.end();
	while (astart!=astop) {
		aterm=*astart;
		ret->insert_term(aterm->coeff, aterm->exp);
		astart++;
	}
	while (bstart!=bstop) {
		bterm=*bstart;
		ret->insert_term(bterm->coeff ,bterm->exp);
		bstart++;
	}

	return(ret);
}

string Poly::equ(void) {
	list<struct PolyTerm *>::iterator start, stop, start_s;
	struct PolyTerm *tmp;
	stringstream cs;
	static string str;

	start_s=start=polyterms.begin();
	stop=polyterms.end();
	cs << "(";
	while (start!=stop) {
		tmp=*start;
		if (tmp->coeff<0) {
			cs << " - ";
		} else {
			if (start!=start_s) cs << " + ";
		}
		if (tmp->exp==0) {
			cs << abs(tmp->coeff);
		} else {
			cs << abs(tmp->coeff) << "x^" << tmp->exp;
		}
		start++;
	}
	cs << ")";
	str=cs.str();
	return(str);
}

double Poly::Evaluate(double x) {
	list<struct PolyTerm *>::iterator start, stop;
	struct PolyTerm *tmp;
	double ret;

	start=polyterms.begin();
	stop=polyterms.end();
	while (start!=stop) {
		tmp=*start;
		ret+=(tmp->coeff)*pow(x, tmp->exp);
		start++;
	}
	return(ret);
}

int Poly::Evaluate(int x) {
	list<struct PolyTerm *>::iterator start, stop;
	struct PolyTerm *tmp;
	int ret=0;
	double dx=(double) x;

	start=polyterms.begin();
	stop=polyterms.end();
	while (start!=stop) {
		tmp=*start;
		ret+=(tmp->coeff)*((int) pow(dx, tmp->exp));
		start++;
	}
	return(ret);
}
