
// This file contains the definition of the SortedType class. This class
// uses a binary search tree as its container and provides functions
// for inserting, deleting, and retreiving items.  Functions for
// printing the items in the tree, emptying the tree, and discovering
// the number of items in the tree are also provided.
// 
// This is modified from Dale and Teague's C++ plus Data Structures
// second edition, pp 672-73

#include <fstream>
#include <iostream>

using namespace std;



#ifndef SORTED_TYPE_H
#define SORTED_TYPE_H


/* Assumption: 
ItemType is a type for which the operators "<", "==", and "<<"
are defined--either an appropriate built-in type or a class that overloads
these operators
*/

template<class ItemType>
struct TreeNode
{   
	ItemType info;
	TreeNode* left;
	TreeNode* right;
}; 

template<class ItemType>
class SortedType
{
	public:
		// Class constructor and destructor
		SortedType();
		~SortedType();
		
		int LengthIs();
		int CountNodes(TreeNode<ItemType> *tree);
		
		
		void MakeEmpty(void);
		
		
		bool RetrieveItem(ItemType& item);
		void Retrieve(TreeNode<ItemType> *tree, ItemType& item, bool& found);
		
		void InsertItem(ItemType item);
		void Insert(TreeNode<ItemType>*& tree, ItemType item);
		
		void DeleteItem(ItemType item);
		void Delete(TreeNode<ItemType> *&tree, ItemType item);
		void DeleteNode(TreeNode<ItemType> *&tree);
		void GetPredecessor(TreeNode<ItemType> *tree, ItemType &data);
		
		void Print(TreeNode<ItemType> *tree, std::ofstream& outFile);
		void PrintList(std::ofstream &outFile);
		
		
		
	protected:
		
		TreeNode<ItemType>* root;
		
		
};

#endif


template<class ItemType>
SortedType<ItemType>::SortedType()
{
	root=NULL;
}

template<class ItemType>
int SortedType<ItemType>::LengthIs()
{
	return CountNodes(root);
}


template<class ItemType>
int SortedType<ItemType>::CountNodes(TreeNode<ItemType> *tree)
{
	if(tree == NULL)
		return 0;
	else
		return CountNodes(tree->left) + CountNodes(tree->right) + 1;
}

template<class ItemType>
void SortedType<ItemType>::MakeEmpty(void)
{
	static struct TreeNode<ItemType> *currNode=root;
	struct TreeNode<ItemType> *parent;
	static int level=0;

    if (level==0) currNode=root;
    if (currNode==NULL) return;

    level++;
    if (currNode->left!=NULL) {
        parent=currNode;
        currNode=currNode->left;
        MakeEmpty();
        currNode=parent;
        currNode->left=NULL;
    } 
    if (currNode->right!=NULL) {
        parent=currNode;
        currNode=currNode->right;
        MakeEmpty();
        currNode=parent;
        currNode->right=NULL;
    }
    delete currNode;

    level--;
    if (level==0) root=NULL;
    return;

}

template<class ItemType>
bool SortedType<ItemType>::RetrieveItem(ItemType& item)
{
	bool found;
	Retrieve(root, item, found);
	return(found);
	
}

template<class ItemType>
void SortedType<ItemType>::Retrieve(TreeNode<ItemType> *tree, ItemType& item, bool& found)
{
	if(tree == NULL)
		found = false;
	else if(item < tree->info)
		Retrieve(tree->left, item, found);
	else if(item > tree->info)
		Retrieve(tree->right, item, found);
	else
	{
		item = tree->info;
		found = true;
	}
	
}

template<class ItemType>
void SortedType<ItemType>::InsertItem(ItemType item)
{
	Insert(root, item);
}

template<class ItemType>
void SortedType<ItemType>::Insert(TreeNode<ItemType>*& tree, ItemType item)
{
	if(tree == NULL)
	{
		tree = new TreeNode<ItemType>;
		tree->right = NULL;
		tree->left = NULL;
		tree->info = item;
	}
	
	else if(item < tree->info)
		
		Insert(tree->left, item);
	
	
	else if(item > tree->info)
		
		Insert(tree->right, item);
	
	
}

template<class ItemType>
void SortedType<ItemType>::DeleteItem(ItemType item)
{
	bool located;
	Retrieve(root,item,located);
	if(!located)
	{	
		return;
	}
	Delete(root, item);
}

template<class ItemType>
void SortedType<ItemType>::Delete(TreeNode<ItemType> *&tree, ItemType item)
{
	if(item < tree->info)
		Delete(tree->left, item);
	else if(item > tree->info)
		Delete(tree->right, item);
	else
		DeleteNode(tree);
}

template<class ItemType>
void SortedType<ItemType>::DeleteNode(TreeNode<ItemType> *&tree)
{
	ItemType data;
	TreeNode<ItemType> *tempPtr;
	
	tempPtr = tree;
	
	if(tree->left == NULL)
	{
		tree = tree->right;
		delete tempPtr;
	}
	else if(tree->right == NULL)
	{
		tree = tree->left;
		delete tempPtr;
	}
	else
	{
		GetPredecessor(tree->left, data);
		tree->info = data;
		Delete(tree->left, data);
	}
}

template<class ItemType>
void SortedType<ItemType>::GetPredecessor(TreeNode<ItemType> *tree, ItemType &data)
{
	while(tree->right != NULL)
		tree = tree->right;
	data = tree->info;
}

template<class ItemType>
void SortedType<ItemType>::PrintList(ofstream &outFile)
{
	Print(root, outFile);
	
}


template<class ItemType>
void SortedType<ItemType>::Print(TreeNode<ItemType> *tree, ofstream& outFile)
{
	if(tree != NULL)
	{
		Print(tree->left, outFile);
		outFile<<tree->info << "::";
		Print(tree->right, outFile);
	}
}


template<class ItemType>
SortedType<ItemType>::~SortedType()
{
	MakeEmpty();
}






