#! /bin/bash

# By this time we're read-write.

PATH="/bin:/sbin"
export PATH
mount -t proc proc /proc
mount -o gid=5,mode=620 -t devpts devpts /dev/pts 
hostname webplayer

# Start devfsd if necessary
if [ -r /dev/.devfsd ]; then
  if [ -x /sbin/devfsd ]; then
    echo "Starting devfs daemon:  /sbin/devfsd /dev"
    /sbin/devfsd /dev
  else
    ln -s /dev/fb/0 /dev/fb0
    ln -s /dev/misc/psaux /dev/psaux
  fi
fi

# enable swapping
/sbin/swapon -a

/sbin/hwclock --utc --hctosys

if [ -x /etc/rc.d/rc.syslog ]; then
	/etc/rc.d/rc.syslog &
fi

if [ -x /etc/rc.d/rc.sound ]; then
	/etc/rc.d/rc.sound &
fi

if [ -x /etc/rc.d/rc.gpm ]; then
	/etc/rc.d/rc.gpm &
fi
