/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import java.io.IOException;
import ssh.BigInteger;
import ssh.MD5;
import ssh.SshCrypto;
import ssh.SshMisc;
import ssh.SshPacket;

public class SshPacket2
extends SshPacket {
    private static final boolean debug = true;
    private byte[] packet_length_array = new byte[5];
    private int packet_length = 0;
    private int padlen = 0;
    private byte[] crc_array = new byte[4];
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length;
    private final int PHASE_block;
    private SshCrypto crypto = null;
    private byte[] block;

    public SshPacket2(SshCrypto sshCrypto) {
        this.PHASE_packet_length = 0;
        this.PHASE_block = 1;
        this.position = 0;
        this.phase_packet = 0;
        this.crypto = sshCrypto;
    }

    public SshPacket2(byte by) {
        this.PHASE_packet_length = 0;
        this.PHASE_block = 1;
        this.setType(by);
    }

    public BigInteger getMpInt() {
        return new BigInteger(this.getBytes(this.getInt32()));
    }

    public void putMpInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.putInt32(byArray.length - n);
        this.putBytes(byArray2);
    }

    public byte[] getPayLoad(SshCrypto sshCrypto, long l) throws IOException {
        byte[] byArray;
        Object object;
        int n;
        byte[] byArray2 = this.getData();
        int n2 = 8;
        this.packet_length = 6;
        if (byArray2 != null) {
            this.packet_length += byArray2.length;
        }
        if ((n = n2 - this.packet_length % n2) < 4) {
            n += n2;
        }
        byte[] byArray3 = new byte[n];
        System.out.println("packet length is " + this.packet_length + ", padlen is " + n);
        if (sshCrypto == null) {
            int n3 = 0;
            while (n3 < n) {
                byArray3[n3] = 0;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                byArray3[n4] = SshMisc.getNotZeroRandomByte();
                ++n4;
            }
        }
        byte[] byArray4 = new byte[this.packet_length + n];
        int n5 = n + this.packet_length - 4;
        byArray4[3] = (byte)(n5 & 0xFF);
        byArray4[2] = (byte)(n5 >> 8 & 0xFF);
        byArray4[1] = (byte)(n5 >> 16 & 0xFF);
        byArray4[0] = (byte)(n5 >> 24 & 0xFF);
        byArray4[4] = (byte)n;
        byArray4[5] = this.getType();
        System.arraycopy(byArray2, 0, byArray4, 6, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, 6 + byArray2.length, n);
        if (sshCrypto != null) {
            object = new MD5();
            byte[] byArray5 = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            ((MD5)object).update(byArray5, 0, 4);
            ((MD5)object).update(byArray4, 0, byArray4.length);
            byArray = ((MD5)object).digest();
        } else {
            byArray = new byte[]{};
        }
        if (sshCrypto != null) {
            byArray4 = sshCrypto.encrypt(byArray4);
        }
        object = new byte[byArray4.length + byArray.length];
        System.arraycopy(byArray4, 0, object, 0, byArray4.length);
        System.arraycopy(byArray, 0, object, byArray4.length, byArray.length);
        return object;
    }

    public byte[] addPayload(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        if (this.crypto != null) {
            n2 = 16;
        }
        System.out.println("addPayload2 " + byArray.length);
        while (n < byArray.length) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position != 5) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.padlen = this.packet_length_array[4];
                    this.position = 0;
                    System.out.println("SSH2: packet length " + this.packet_length);
                    System.out.println("SSH2: padlen " + this.padlen);
                    this.packet_length += n2;
                    this.block = new byte[this.packet_length - 1];
                    ++this.phase_packet;
                    break;
                }
                case 1: {
                    int n3;
                    if (this.position < this.block.length && (n3 = byArray.length - n) > 0) {
                        if (n3 > this.block.length - this.position) {
                            n3 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n3);
                        n += n3;
                        this.position += n3;
                    }
                    if (this.position != this.block.length) break;
                    if (byArray.length > n) {
                        byArray2 = new byte[byArray.length - n];
                        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
                    }
                    byte[] byArray3 = new byte[this.block.length - n2];
                    this.packet_length -= n2;
                    System.arraycopy(this.block, 0, byArray3, 0, this.block.length - n2);
                    if (this.crypto != null) {
                        byArray3 = this.crypto.decrypt(byArray3);
                    }
                    int n4 = 0;
                    while (n4 < byArray3.length) {
                        System.out.print(" " + byArray3[n4]);
                        ++n4;
                    }
                    System.out.println("");
                    this.setType(byArray3[0]);
                    System.err.println("Packet type: " + this.getType());
                    System.err.println("Packet len: " + this.packet_length);
                    if (this.packet_length > this.padlen + 1 + 1) {
                        byte[] byArray4 = new byte[this.packet_length - 1 - this.padlen - 1];
                        System.arraycopy(byArray3, 1, byArray4, 0, byArray4.length);
                        this.putData(byArray4);
                    } else {
                        this.putData(null);
                    }
                    return byArray2;
                }
            }
        }
        return null;
    }
}

