/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import telnet.Action;
import telnet.DrawFont;
import telnet.InputDialog;
import telnet.SelectFunctionDlg;
import telnet.Telnet;
import telnet.vt320;

public class MidletTerminal
extends Canvas
implements CommandListener {
    private vt320 buffer;
    private int top;
    private int left;
    public int rows;
    public int cols;
    private Image backingStore = null;
    private DrawFont font;
    public int fgcolor = 0;
    public int bgcolor = 0xFFFFFF;
    private int[] color = new int[]{0, 0xFF0000, 65280, 0xFFFF00, 255, 65535, 65535, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    public static final int COLOR_INVERT = 9;
    public Hashtable bindings = new Hashtable();

    public MidletTerminal(vt320 vt3202) {
        this.buffer = vt3202;
        if (Telnet.useColors) {
            this.fgcolor = 0xFFFFFF;
            this.bgcolor = 0;
        }
        this.font = new DrawFont();
        this.backingStore = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        int n = this.getWidth();
        this.font.getClass();
        this.cols = n / 4;
        int n2 = this.getHeight();
        this.font.getClass();
        this.rows = n2 / 6;
        vt3202.setScreenSize(this.cols, this.rows);
        this.top = 0;
        this.left = 0;
        this.loadBindings();
        this.displayHelp();
    }

    public void commandAction(Command command, Displayable displayable) {
        Telnet.setDisplay((Displayable)new SelectFunctionDlg());
    }

    protected void keyPressed(int n) {
        Object v = this.bindings.get(new Integer(n += 64));
        if (v == null) {
            Telnet.setDisplay((Displayable)new SelectFunctionDlg());
            return;
        }
        Action action = (Action)v;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n2 = Integer.parseInt(action.arg0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n3 = Integer.parseInt(action.arg1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n4 = Integer.parseInt(action.arg2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (action.funct.hashCode()) {
            case 619943518: {
                InputDialog inputDialog = new InputDialog();
                inputDialog.setString(action.arg0);
                Telnet.setDisplay((Displayable)inputDialog);
                break;
            }
            case -1961870716: {
                this.displayHelp();
                break;
            }
            case 2007032186: {
                this.left = this.left >= n2 ? (this.left -= n2) : 0;
                this.redraw();
                break;
            }
            case 2094116617: {
                this.left = this.left + n2 + this.cols <= this.buffer.width ? (this.left += n2) : this.buffer.width - this.cols;
                this.redraw();
                break;
            }
            case 417730766: {
                this.top = this.top >= n2 ? (this.top -= n2) : 0;
                this.redraw();
                break;
            }
            case 2006803989: {
                this.top = this.top + n2 + this.rows < this.buffer.height ? (this.top += n2) : this.buffer.height - this.rows;
                this.redraw();
                break;
            }
            case 800818103: {
                String string = action.arg0;
                int n5 = 0;
                while (n5 < string.length()) {
                    Telnet.emulation.keyTyped(0, string.charAt(n5), 0);
                    ++n5;
                }
                break;
            }
            case -578494887: {
                String string = action.arg0;
                int n6 = 0;
                while (n6 < string.length()) {
                    Telnet.emulation.keyTyped(0, string.charAt(n6), 0);
                    ++n6;
                }
                Telnet.emulation.keyTyped(0, '\n', 0);
                break;
            }
            case -1709828255: {
                Telnet.emulation.keyPressed(n2, (char)n3, n4);
                break;
            }
            case 846825321: {
                if (action.arg2.length() != 0) {
                    Telnet.emulation.keyTyped(n2, (char)n3, n4);
                    break;
                }
                char c = (char)(action.arg0.charAt(action.arg0.length() - 1) - 97 + 1);
                if (action.arg0.equals("tab")) {
                    Telnet.emulation.keyTyped(0, '\t', 0);
                    break;
                }
                Telnet.emulation.keyTyped(0, c, this.getModifiers(action.arg0));
                break;
            }
            case 1357349119: {
                Telnet.emulation.setScreenSize(n2, n3);
                break;
            }
            case 951351530: {
                Telnet.host = action.arg0;
                Telnet.sshIO.login = action.arg1;
                Telnet.sshIO.password = action.arg2;
                Telnet.reader.start();
                break;
            }
            case -1067310595: {
                Telnet.console.append(Telnet.traffic / 1024 + "kb");
                Telnet.setDisplay((Displayable)Telnet.console);
                break;
            }
            case 916242154: {
                this.bgcolor = n4 | n3 << 8 | n2 << 16;
                this.redraw();
                break;
            }
            case -62074113: {
                this.fgcolor = n4 | n3 << 8 | n2 << 16;
                this.redraw();
                break;
            }
            case 525682396: {
                Telnet.setDisplay((Displayable)Telnet.console);
                break;
            }
            case 513124271: {
                this.buffer.setBufferSize(n2);
                break;
            }
            case -1553380089: {
                this.buffer.setWindowBase(this.buffer.getWindowBase() - n2);
                break;
            }
            case 1849849870: {
                this.buffer.setWindowBase(this.buffer.getWindowBase() + n2);
                break;
            }
            case -2023294142: {
                Telnet.emulation.putString(this.buffer.width + "x" + this.buffer.height);
                this.redraw();
                break;
            }
            case -1895224076: {
                Telnet.sleepTime = n2;
                break;
            }
            case 656383028: {
                Telnet.keepAliveCycles = 1000 * n2 / Telnet.sleepTime;
                break;
            }
            case -514479728: {
                Telnet.quitApp();
            }
        }
    }

    private int brighten(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        n2 *= 12;
        if ((n2 /= 10) > 255) {
            n2 = 255;
        }
        n3 *= 12;
        if ((n3 /= 10) > 255) {
            n3 = 255;
        }
        n4 *= 12;
        if ((n4 /= 10) > 255) {
            n4 = 255;
        }
        return n4 | n3 << 8 | n2 << 16;
    }

    private int darken(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        n2 *= 8;
        n3 *= 8;
        n4 *= 8;
        return (n4 /= 10) | (n3 /= 10) << 8 | (n2 /= 10) << 16;
    }

    protected void paint(Graphics graphics) {
        graphics.drawImage(this.backingStore, 0, 0, 0);
    }

    public void redraw() {
        Graphics graphics = this.backingStore.getGraphics();
        int n = this.top;
        while (n < this.buffer.height && n < this.top + this.rows) {
            if (this.buffer.update[0] || this.buffer.update[n + 1]) {
                this.buffer.update[n + 1] = false;
                int n2 = this.left;
                while (n2 < this.buffer.width && n2 < this.left + this.cols) {
                    int n3 = 0;
                    int n4 = this.buffer.charAttributes[this.buffer.windowBase + n][n2];
                    int n5 = this.darken(this.fgcolor);
                    int n6 = this.darken(this.bgcolor);
                    if ((n4 & 0xF0) != 0) {
                        n5 = this.darken(this.color[((n4 & 0xF0) >> 4) - 1]);
                    }
                    if ((n4 & 0xF00) != 0) {
                        n6 = this.darken(this.darken(this.color[((n4 & 0xF00) >> 8) - 1]));
                    }
                    if ((n4 & 8) != 0) {
                        n5 = this.darken(n5);
                    }
                    if ((n4 & 4) != 0) {
                        int n7 = n6;
                        n6 = n5;
                        n5 = n7;
                    }
                    while (n2 + n3 < this.buffer.width && (this.buffer.charArray[this.buffer.windowBase + n][n2 + n3] < ' ' || this.buffer.charAttributes[this.buffer.windowBase + n][n2 + n3] == n4)) {
                        if (this.buffer.charArray[this.buffer.windowBase + n][n2 + n3] < ' ') {
                            this.buffer.charArray[this.buffer.windowBase + n][n2 + n3] = 32;
                            this.buffer.charAttributes[this.buffer.windowBase + n][n2 + n3] = 0;
                            continue;
                        }
                        ++n3;
                    }
                    if (Telnet.useColors) {
                        graphics.setColor(n6);
                    } else {
                        graphics.setColor(this.bgcolor);
                    }
                    this.font.getClass();
                    this.font.getClass();
                    this.font.getClass();
                    this.font.getClass();
                    graphics.fillRect((n2 - this.left) * 4, (n - this.top) * 6, n3 * 4, 6);
                    if (Telnet.useColors) {
                        graphics.setColor(n5);
                    } else {
                        graphics.setColor(this.fgcolor);
                    }
                    char[] cArray = this.buffer.charArray[this.buffer.windowBase + n];
                    this.font.getClass();
                    this.font.getClass();
                    this.font.drawChars(graphics, cArray, n2, n3, (n2 - this.left) * 4, (n - this.top) * 6);
                    n2 += n3 - 1;
                    ++n2;
                }
            }
            ++n;
        }
        if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
            graphics.setColor(this.fgcolor);
            int n8 = this.buffer.cursorX - this.left;
            this.font.getClass();
            int n9 = n8 * 4;
            int n10 = this.buffer.cursorY - this.top + this.buffer.screenBase - this.buffer.windowBase;
            this.font.getClass();
            int n11 = n10 * 6;
            this.font.getClass();
            this.font.getClass();
            graphics.fillRect(n9, n11, 4, 6);
        }
        this.repaint();
    }

    public void setVDUBuffer(vt320 vt3202) {
        this.buffer = vt3202;
        vt3202.setDisplay(this);
    }

    public void loadBindings() {
        this.bindings = new Hashtable();
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"binds", (boolean)false);
        }
        catch (Exception exception) {
            this.bindings.put(new Integer(113), new Action("connect", "158.194.80.13", "polakr", "pwd"));
            this.bindings.put(new Integer(117), new Action("input dialog", "", "", ""));
            this.bindings.put(new Integer(106), new Action("key pressed", "37", "65535", "8"));
            this.bindings.put(new Integer(99), new Action("key pressed", "39", "65535", "8"));
            this.bindings.put(new Integer(120), new Action("key pressed", "38", "65535", "8"));
            this.bindings.put(new Integer(112), new Action("key pressed", "40", "65535", "8"));
            this.bindings.put(new Integer(121), new Action("view console", "", "", ""));
            return;
        }
        try {
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                while (dataInputStream.available() > 0) {
                    this.bindings.put(new Integer(dataInputStream.readInt()), new Action(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readUTF()));
                }
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveBindings() {
        try {
            Object object;
            try {
                RecordStore.deleteRecordStore((String)"binds");
            }
            catch (Exception exception) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"binds", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = 0;
            while (n < 128) {
                object = this.bindings.get(new Integer(n));
                if (object != null) {
                    Action action = (Action)object;
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(action.funct);
                    dataOutputStream.writeUTF(action.arg0);
                    dataOutputStream.writeUTF(action.arg1);
                    dataOutputStream.writeUTF(action.arg2);
                }
                ++n;
            }
            dataOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(object, 0, ((byte[])object).length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void displayHelp() {
        String string = "";
        int n = 0;
        while (n < 128) {
            Object v = this.bindings.get(new Integer(n));
            if (v != null) {
                Action action = (Action)v;
                String string2 = this.getKeyName(n - 64) + " - " + action.funct + " " + action.arg0 + " " + action.arg1 + " " + action.arg2;
                string = string + string2 + "\n\r";
                if (Telnet.socket != null) {
                    Telnet.console.append(string2);
                }
            }
            ++n;
        }
        if (Telnet.socket != null) {
            Telnet.setDisplay((Displayable)Telnet.console);
        } else {
            this.buffer.deleteArea(0, 0, this.buffer.width, this.buffer.height);
            this.buffer.R = 0;
            this.buffer.C = 0;
            Telnet.emulation.putString(string);
            this.redraw();
        }
    }

    public int getModifiers(String string) {
        int n = 0;
        if (string.indexOf("ctrl") != -1) {
            n |= 1;
        }
        if (string.indexOf("shift") != -1) {
            n |= 2;
        }
        if (string.indexOf("alt") != -1) {
            n |= 4;
        }
        return n;
    }
}

