/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import ssh.SshIO;
import telnet.Console;
import telnet.MidletTerminal;
import telnet.vt320;

public class Telnet
extends MIDlet
implements Runnable {
    private static Telnet instance;
    public static vt320 emulation;
    public static MidletTerminal terminal;
    public static Console console;
    public static byte[] output;
    public static int outputCount;
    public static SshIO sshIO;
    public static int traffic;
    public static int sleepTime;
    public static int keepAliveCycles;
    public static StreamConnection socket;
    private static DataInputStream in;
    public static DataOutputStream out;
    public static String host;
    public static Thread reader;
    public static boolean useColors;

    public Telnet() {
        instance = this;
        useColors = this.getDisplay().isColor();
        emulation = new vt320();
        terminal = new MidletTerminal(emulation);
        sshIO = new SshIO();
    }

    public void startApp() {
        Telnet.setDisplay((Displayable)terminal);
        reader = new Thread(this);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public static void setDisplay(Displayable displayable) {
        instance.getDisplay().setCurrent(displayable);
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void run() {
        int n = 0;
        try {
            emulation.putString("Connecting...");
            terminal.redraw();
            socket = (StreamConnection)Connector.open((String)("socket://" + host + ":22"), (int)3, (boolean)false);
            in = socket.openDataInputStream();
            out = socket.openDataOutputStream();
            emulation.putString("OK");
        }
        catch (Exception exception) {
            emulation.putString("FAILED");
        }
        emulation.putString("\n\r");
        terminal.redraw();
        try {
            while (true) {
                int n2;
                if ((n2 = in.available()) <= 0) {
                    if (outputCount > 0) {
                        traffic += outputCount;
                        out.write(output, 0, outputCount);
                        outputCount = 0;
                        continue;
                    }
                    Thread.sleep(sleepTime);
                    if (n++ <= keepAliveCycles) continue;
                    emulation.keyTyped(0, 'a', 0);
                    emulation.keyPressed(8, '\b', 0);
                    n = 0;
                    continue;
                }
                byte[] byArray = new byte[n2];
                in.read(byArray, 0, n2);
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byte[] byArray3 = sshIO.handleSSH(byArray2);
                if (byArray3 != null && byArray3.length > 0 && n2 > 0) {
                    try {
                        emulation.putString(new String(byArray3));
                        terminal.redraw();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                n = 0;
            }
        }
        catch (Exception exception) {
            console.append(exception.getMessage());
            return;
        }
    }

    static {
        console = new Console();
        output = new byte[16];
        outputCount = 0;
        sshIO = null;
        traffic = 0;
        sleepTime = 1000;
        keepAliveCycles = 300;
    }
}

