/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import telnet.MidletTerminal;

public class VDUBuffer {
    public int height;
    public int width;
    public boolean[] update;
    public char[][] charArray;
    public int[][] charAttributes;
    public int bufSize;
    public int maxBufSize;
    public int screenBase;
    public int windowBase;
    public int scrollMarker;
    private int topMargin;
    private int bottomMargin;
    protected boolean showcursor = true;
    protected int cursorX;
    protected int cursorY;
    public static final boolean SCROLL_UP = false;
    public static final boolean SCROLL_DOWN = true;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;
    public static final int LOW = 8;
    public static final int COLOR = 4080;
    public static final int COLOR_FG = 240;
    public static final int COLOR_BG = 3840;
    protected MidletTerminal display;

    public VDUBuffer(int n, int n2) {
        this.setScreenSize(n, n2);
    }

    public void putChar(int n, int n2, char c) {
        this.putChar(n, n2, c, 0);
    }

    public void putChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        this.charArray[this.screenBase + n2][n] = c;
        this.charAttributes[this.screenBase + n2][n] = n3;
        this.markLine(n2, 1);
    }

    public char getChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        return this.charArray[this.screenBase + n2][n];
    }

    public int getAttributes(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        return this.charAttributes[this.screenBase + n2][n];
    }

    public void insertChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        System.arraycopy(this.charArray[this.screenBase + n2], n, this.charArray[this.screenBase + n2], n + 1, this.width - n - 1);
        System.arraycopy(this.charAttributes[this.screenBase + n2], n, this.charAttributes[this.screenBase + n2], n + 1, this.width - n - 1);
        this.putChar(n, n2, c, n3);
    }

    public void deleteChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        if (n < this.width - 1) {
            System.arraycopy(this.charArray[this.screenBase + n2], n + 1, this.charArray[this.screenBase + n2], n, this.width - n - 1);
            System.arraycopy(this.charAttributes[this.screenBase + n2], n + 1, this.charAttributes[this.screenBase + n2], n, this.width - n - 1);
        }
        this.putChar(this.width - 1, n2, '\u0000');
    }

    public void putString(int n, int n2, String string) {
        this.putString(n, n2, string, 0);
    }

    public void putString(int n, int n2, String string, int n3) {
        int n4 = 0;
        while (n4 < string.length() && n + n4 < this.width) {
            this.putChar(n + n4, n2, string.charAt(n4), n3);
            ++n4;
        }
    }

    public void insertLine(int n) {
        this.insertLine(n, 1, false);
    }

    public void insertLine(int n, int n2) {
        this.insertLine(n, n2, false);
    }

    public void insertLine(int n, boolean bl) {
        this.insertLine(n, 1, bl);
    }

    public synchronized void insertLine(int n, int n2, boolean bl) {
        int n3;
        int n4;
        n = this.checkBounds(n, 0, this.height - 1);
        char[][] cArray = null;
        int[][] nArray = null;
        int n5 = 0;
        int n6 = this.screenBase;
        if (n > this.bottomMargin) {
            return;
        }
        int n7 = n < this.topMargin ? 0 : (n > this.bottomMargin ? (this.bottomMargin + 1 < this.height ? this.bottomMargin + 1 : this.height - 1) : (n4 = this.topMargin));
        int n8 = n > this.bottomMargin ? this.height - 1 : (n < this.topMargin ? (this.topMargin > 0 ? this.topMargin - 1 : 0) : (n3 = this.bottomMargin));
        if (bl) {
            if (n2 > n3 - n4) {
                n2 = n3 - n4;
            }
            cArray = new char[n3 - n - (n2 - 1)][this.width];
            nArray = new int[n3 - n - (n2 - 1)][this.width];
            System.arraycopy(this.charArray, n6 + n, cArray, 0, n3 - n - (n2 - 1));
            System.arraycopy(this.charAttributes, n6 + n, nArray, 0, n3 - n - (n2 - 1));
            System.arraycopy(cArray, 0, this.charArray, n6 + n + n2, n3 - n - (n2 - 1));
            System.arraycopy(nArray, 0, this.charAttributes, n6 + n + n2, n3 - n - (n2 - 1));
            cArray = this.charArray;
            nArray = this.charAttributes;
        } else {
            try {
                if (n2 > n3 - n4 + 1) {
                    n2 = n3 - n4 + 1;
                }
                if (this.bufSize < this.maxBufSize) {
                    if (this.bufSize + n2 > this.maxBufSize) {
                        n5 = n2 - (this.maxBufSize - this.bufSize);
                        this.scrollMarker += n5;
                        this.bufSize = this.maxBufSize;
                        this.windowBase = this.screenBase = this.maxBufSize - this.height - 1;
                    } else {
                        this.scrollMarker += n2;
                        this.screenBase += n2;
                        this.windowBase += n2;
                        this.bufSize += n2;
                    }
                    cArray = new char[this.bufSize][this.width];
                    nArray = new int[this.bufSize][this.width];
                } else {
                    n5 = n2;
                    cArray = this.charArray;
                    nArray = this.charAttributes;
                }
                if (n6 > 0) {
                    System.arraycopy(this.charArray, n5, cArray, 0, n6 - n5);
                    System.arraycopy(this.charAttributes, n5, nArray, 0, n6 - n5);
                }
                if (n4 > 0) {
                    System.arraycopy(this.charArray, n6, cArray, this.screenBase, n4);
                    System.arraycopy(this.charAttributes, n6, nArray, this.screenBase, n4);
                }
                if (n6 > 0) {
                    System.arraycopy(this.charArray, n6 + n4, cArray, n6 - n5, n2);
                    System.arraycopy(this.charAttributes, n6 + n4, nArray, n6 - n5, n2);
                }
                int n9 = 0;
                while (n9 < n - n4 - (n2 - 1)) {
                    cArray[this.screenBase + n4 + n9] = this.charArray[n6 + n4 + n2 + n9];
                    nArray[this.screenBase + n4 + n9] = this.charAttributes[n6 + n4 + n2 + n9];
                    ++n9;
                }
                if (n < this.height - 1) {
                    System.arraycopy(this.charArray, n6 + n + 1, cArray, this.screenBase + n + 1, this.height - 1 - n);
                    System.arraycopy(this.charAttributes, n6 + n + 1, nArray, this.screenBase + n + 1, this.height - 1 - n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("*** Error while scrolling up:");
                System.err.println("--- BEGIN STACK TRACE ---");
                arrayIndexOutOfBoundsException.printStackTrace();
                System.err.println("--- END STACK TRACE ---");
                System.err.println("bufSize=" + this.bufSize + ", maxBufSize=" + this.maxBufSize);
                System.err.println("top=" + n4 + ", bottom=" + n3);
                System.err.println("n=" + n2 + ", l=" + n);
                System.err.println("screenBase=" + this.screenBase + ", windowBase=" + this.windowBase);
                System.err.println("oldBase=" + n6);
                System.err.println("size.width=" + this.width + ", size.height=" + this.height);
                System.err.println("abuf.length=" + nArray.length + ", cbuf.length=" + cArray.length);
                System.err.println("*** done dumping debug information");
            }
        }
        this.scrollMarker -= n2;
        int n10 = 0;
        while (n10 < n2) {
            cArray[this.screenBase + n + (bl ? n10 : -n10)] = new char[this.width];
            nArray[this.screenBase + n + (bl ? n10 : -n10)] = new int[this.width];
            ++n10;
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        if (bl) {
            this.markLine(n, n3 - n + 1);
        } else {
            this.markLine(n4, n - n4 + 1);
        }
    }

    public void deleteLine(int n) {
        int n2 = (n = this.checkBounds(n, 0, this.height - 1)) > this.bottomMargin ? this.height - 1 : (n < this.topMargin ? this.topMargin : this.bottomMargin + 1);
        System.arraycopy(this.charArray, this.screenBase + n + 1, this.charArray, this.screenBase + n, n2 - n - 1);
        System.arraycopy(this.charAttributes, this.screenBase + n + 1, this.charAttributes, this.screenBase + n, n2 - n - 1);
        this.charArray[this.screenBase + n2 - 1] = new char[this.width];
        this.charAttributes[this.screenBase + n2 - 1] = new int[this.width];
        this.markLine(n, n2 - n);
    }

    public void deleteArea(int n, int n2, int n3, int n4, int n5) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        char[] cArray = new char[n3];
        int[] nArray = new int[n3];
        int n6 = 0;
        while (n6 < n3) {
            nArray[n6] = n5;
            ++n6;
        }
        int n7 = 0;
        while (n7 < n4 && n2 + n7 < this.height) {
            System.arraycopy(cArray, 0, this.charArray[this.screenBase + n2 + n7], n, n3);
            System.arraycopy(nArray, 0, this.charAttributes[this.screenBase + n2 + n7], n, n3);
            ++n7;
        }
        this.markLine(n2, n4);
    }

    public void deleteArea(int n, int n2, int n3, int n4) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        char[] cArray = new char[n3];
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n4 && n2 + n5 < this.height) {
            System.arraycopy(cArray, 0, this.charArray[this.screenBase + n2 + n5], n, n3);
            System.arraycopy(nArray, 0, this.charAttributes[this.screenBase + n2 + n5], n, n3);
            ++n5;
        }
        this.markLine(n2, n4);
    }

    public void showCursor(boolean bl) {
        if (bl != this.showcursor) {
            this.markLine(this.cursorY, 1);
        }
        this.showcursor = bl;
    }

    public void setCursorPosition(int n, int n2) {
        this.cursorX = this.checkBounds(n, 0, this.width - 1);
        this.cursorY = this.checkBounds(n2, 0, this.height - 1);
        this.markLine(this.cursorY, 1);
    }

    public int getCursorColumn() {
        return this.cursorX;
    }

    public int getCursorRow() {
        return this.cursorY;
    }

    public void setWindowBase(int n) {
        if (n > this.screenBase) {
            n = this.screenBase;
        } else if (n < 0) {
            n = 0;
        }
        this.windowBase = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getWindowBase() {
        return this.windowBase;
    }

    public void setTopMargin(int n) {
        if (n > this.bottomMargin) {
            this.topMargin = this.bottomMargin;
            this.bottomMargin = n;
        } else {
            this.topMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(int n) {
        if (n < this.topMargin) {
            this.bottomMargin = this.topMargin;
            this.topMargin = n;
        } else {
            this.bottomMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBufferSize(int n) {
        if (n < this.height) {
            n = this.height;
        }
        if (n < this.maxBufSize) {
            int n2;
            char[][] cArray = new char[n][this.width];
            int[][] nArray = new int[n][this.width];
            int n3 = this.bufSize - n < 0 ? 0 : this.bufSize - n;
            int n4 = n2 = this.bufSize - n < 0 ? this.bufSize : n;
            if (this.charArray != null) {
                System.arraycopy(this.charArray, n3, cArray, 0, n2);
            }
            if (this.charAttributes != null) {
                System.arraycopy(this.charAttributes, n3, nArray, 0, n2);
            }
            this.charArray = cArray;
            this.charAttributes = nArray;
            this.bufSize = n2;
            this.windowBase = this.screenBase = this.bufSize - this.height;
        }
        this.maxBufSize = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufSize;
    }

    public void setScreenSize(int n, int n2) {
        int n3 = this.bufSize;
        if (n < 1 || n2 < 1) {
            return;
        }
        if (n2 > this.maxBufSize) {
            this.maxBufSize = n2;
        }
        if (n2 > this.bufSize) {
            this.bufSize = n2;
            this.screenBase = 0;
            this.windowBase = 0;
        }
        if (this.windowBase + n2 >= this.bufSize) {
            this.windowBase = this.bufSize - n2;
        }
        if (this.screenBase + n2 >= this.bufSize) {
            this.screenBase = this.bufSize - n2;
        }
        char[][] cArray = new char[this.bufSize][n];
        int[][] nArray = new int[this.bufSize][n];
        if (this.charArray != null && this.charAttributes != null) {
            int n4 = 0;
            while (n4 < n3 && n4 < this.bufSize) {
                System.arraycopy(this.charArray[n4], 0, cArray[n4], 0, n < this.width ? n : this.width);
                System.arraycopy(this.charAttributes[n4], 0, nArray[n4], 0, n < this.width ? n : this.width);
                ++n4;
            }
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        this.width = n;
        this.height = n2;
        this.topMargin = 0;
        this.bottomMargin = n2 - 1;
        this.update = new boolean[n2 + 1];
        this.update[0] = true;
    }

    public void markLine(int n, int n2) {
        n = this.checkBounds(n, 0, this.height - 1);
        int n3 = 0;
        while (n3 < n2 && n + n3 < this.height) {
            this.update[n + n3 + 1] = true;
            ++n3;
        }
    }

    private int checkBounds(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void setDisplay(MidletTerminal midletTerminal) {
        this.display = midletTerminal;
    }

    protected void redraw() {
        if (this.display != null) {
            this.display.redraw();
        }
    }
}

