/*

				Global application initialisation
				
*/

#include "netfone.h"

static LPSTR pszFrameClass;				// MDI frame window class
LPSTR pszMDIClientClass;				// MDI client window class
LPSTR pszClientClass;					// MDI child window class
static LPSTR pszServerClass;			// MDI child window class

//	INITAPPLICATION  --  Initialise globals and register classes

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS WndClass;

    hInst = hInstance;

    //  Initialise some of the global strings

    pszAppName = "Speak Freely";
    pszFrameClass = "SpeakFreeFrameClass";
    pszMDIClientClass = "MDICLIENT";
    pszClientClass = "SpeakFreeClientClass";

    //  Initialise & register the various window classes
    
    //	Main (frame) window

    WndClass.style = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc = (WNDPROC) Frame_WndProc;
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
    WndClass.hInstance = hInstance;
    WndClass.hIcon = LoadIcon(hInstance, IDI_FRAME);
    WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    WndClass.lpszMenuName = IDM_FRAME;
    WndClass.lpszClassName = pszFrameClass;

    if (!RegisterClass(&WndClass)) {
        return FALSE;
    }
    
    //	Connection client window
    
    WndClass.style |= CS_DBLCLKS;
    WndClass.lpfnWndProc = (WNDPROC) connectWndProc;
    WndClass.cbWndExtra = sizeof(LPVOID);
    WndClass.hCursor = NULL;
    WndClass.hIcon = LoadIcon(hInstance, IDI_CLIENT);
    WndClass.lpszMenuName = NULL;
    WndClass.lpszClassName = pszClientClass;

    if (!RegisterClass(&WndClass)) {
        return FALSE;
    }
    return TRUE;
}

//	INITINSTANCE  --  Initialise a new instance

BOOL InitInstance(HINSTANCE hInstance, LPSTR pszCmdLine, INT nCmdShow)
{
	RECT r;
	
	/*	Save the command line so we can use it later to open a
		connection file specified there.  */

	if (_fstrlen(pszCmdLine) > 0) {
		commandLine = (LPSTR) GlobalAllocPtr(GPTR, _fstrlen(pszCmdLine) + 1);
		if (commandLine != NULL) {
			_fstrcpy(commandLine, pszCmdLine);
		}
	}	
	
    //  Create the frame window

	GetWindowRect(GetDesktopWindow(), &r);
    hwndMDIFrame = CreateWindow(pszFrameClass, pszAppName, WS_OVERLAPPEDWINDOW,
                                 CW_USEDEFAULT, CW_USEDEFAULT,
                                 (r.right - r.left) / 2, (r.bottom - r.top) / 2,
                                 NULL, NULL, hInstance, NULL);

    if (hwndMDIFrame == NULL) {
        return FALSE;
    }

    //  Load our accelerators

    hAccel = LoadAccelerators(hInst, IDA_FRAME);

    if (hAccel == NULL) {
        return FALSE;
    }

    //  Display the main window

    ShowWindow(hwndMDIFrame, nCmdShow);
    UpdateWindow(hwndMDIFrame);
    return TRUE;
}

