/*

			Master include file
			
*/

//  System include files

#include <windows.h>
#include <shellapi.h>
#define _INC_SHELLAPI
#include <windowsx.h>
#include <winsock.h>
#include <mmsystem.h>

#ifndef RC_INVOKED

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <time.h>
#include <commdlg.h>

//	Application include files

#include "md5.h"
#include "des.h"
#include "idea.h"
#include "ulaw.h"
#include "gsm.h"
#include "adpcm_u.h"

#endif

#include "resource.h"

//  Socket used to exchange sound packets

#define NETFONE_COMMAND_PORT           2074

//	If defined, show rant about serial I/O on comm errors

#define RANT_ON_ERROR

//  Maximum length (in characters) of a host name

#define MAX_HOST                        256

//  Get/SetWindowLong offsets

#define GWL_CLIENT                      0               // Client-side data

//  Type fields for client/server window data structures

#define WINDOW_TYPE_CLIENT              1

//  Various timeouts in seconds

#define FRAME_TIMER_ID                  1

#define TIMEOUT_CONNECTION				30				// Remote connection timeout
#define TIMEOUT_AUDIO_OUTPUT			10				// Release audio output timeout

//  Maximum printf-like output allowed by MsgBox

#define MAX_PRINTF_OUTPUT               1024

//	Number of recent connections to remember

#define REMEMBER_CONNECTIONS	5

//	Multicast definitions missing from WINSOCK.H

#ifndef IN_MULTICAST
#define IN_MULTICAST(i) ((ntohl((long)(i)) & 0xF0000000) == 0xE0000000)
#endif

//  Messages posted by the asynchronous socket APIs

#define WM_SOCKET_SELECT                (WM_USER + 100)
#define WM_SOCKET_ASYNC                 (WM_USER + 101)

/* void Cls_OnSocketSelect(HWND hwnd, SOCKET sock, SOCKERR serr,
                           SOCKEVENT sevent) */
#define HANDLE_WM_SOCKET_SELECT(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (SOCKET)(wParam), (SOCKERR)WSAGETSELECTERROR(lParam), \
    (SOCKEVENT)WSAGETSELECTEVENT(lParam)), 0L)
#define FORWARD_WM_SOCKET_SELECT(hwnd, socket, serr, sevent, fn) \
    (void)(fn)((hwnd), WM_SOCKET_SELECT, (WPARAM)(socket), \
    (LPARAM)WSAMAKESELECTREPLY(sevent, serr))

/* void Cls_OnSocketAsync(HWND hwnd, HANDLE hAsync, SOCKERR serr,
                          WORD cbBuffer) */
#define HANDLE_WM_SOCKET_ASYNC(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (HANDLE)(wParam), (SOCKERR)WSAGETASYNCERROR(lParam), \
    (WORD)WSAGETASYNCBUFLEN(lParam)), 0L)
#define FORWARD_WM_GETXBYX(hwnd, hAsync, serr, cbBuffer, fn) \
    (void)(fn)((hwnd), WM_SOCKET_ASYNC, (WPARAM)(hAsync), \
    (LPARAM)WSAMAKEASYNCREPLY(cbBuffer, serr))

//  Some useful constants missing from 16-bit Windows

#ifndef WIN32
#define MAX_PATH	260             // characters
#endif

//  Determine number of elements in an array

#define ELEMENTS(array) (sizeof(array)/sizeof((array)[0]))

//	Macro for retrieving formats from the resource file

#define Format(n)   rstring(IDS_FORMATS + (n))

/*	Force a resource string to be FAR for those (like wsprintf)
	who can't figure out by themselves.  */
	
#define Lrstring(n)	((LPSTR) rstring(n))

//  Make life with RC a little easier

#ifdef RC_INVOKED
#define ID(x)           x
#else
#define ID(x)           MAKEINTRESOURCE(x)
#endif

///	Resource IDs

#define IDI_BASE                        1000
#define IDM_BASE                        2000
#define IDD_BASE                        3000
#define IDA_BASE                        4000

//  Icon resource IDs

#define IDI_FRAME                       ID(1000)        // IDI_BASE + 0
#define IDI_CLIENT                      ID(1001)        // IDI_BASE + 1
#define IDI_SERVER                      ID(1002)        // IDI_BASE + 2

//  Menu resource IDs

#define IDM_FRAME_BASE                  2000            // IDM_BASE + 0
#define IDM_FRAME                       ID(IDM_FRAME_BASE)
#define IDM_CONNECTION_BASE             (IDM_FRAME_BASE + 0)
#define IDM_CONNECTION_EXIT             (IDM_CONNECTION_BASE + 3)

#define IDM_WINDOW_BASE                 (IDM_FRAME_BASE + 100)
#define IDM_WINDOW_CASCADE              (IDM_WINDOW_BASE + 0)
#define IDM_WINDOW_TILE_VERTICALLY      (IDM_WINDOW_BASE + 1)
#define IDM_WINDOW_TILE_HORIZONTALLY    (IDM_WINDOW_BASE + 2)
#define IDM_WINDOW_ARRANGE_ICONS        (IDM_WINDOW_BASE + 3)
#define IDM_WINDOW_FIRST_CHILD          (IDM_WINDOW_BASE + 4)

#define IDM_HELP_BASE                   (IDM_FRAME_BASE + 200)
#define IDM_HELP_ABOUT                  (IDM_HELP_BASE + 0)

#define IDM_CUSTOM						9000			// Custom (remembered file) menu items

//  Dialog resource IDs

#define IDD_ABOUT                       ID(3000)        // IDD_BASE + 0

#define IDD_NEW                         ID(3100)        // IDD_BASE + 100
#define IDD_NEW_HOST                    3101
#define IDD_NEW_HOST_LABEL              3102

//  Accelerator table resource IDs

#define IDA_FRAME                       ID(4000)        // IDA_BASE + 0

#define BUFL			3200			// Sound buffer maximum length (actually less)

#define LONG	long

struct soundbuf {
	LONG compression;
	char sendinghost[16];
	struct {
		LONG buffer_len;
		char buffer_val[BUFL];
	} buffer;
};
typedef struct soundbuf soundbuf;

// Packet mode flags

#define fComp2X     1		      // Simple 2 to 1 compression
#define fDebug	    2		      // Debug mode
#define fSetDest    4		      // Set sound output destination
#define fDestSpkr   0		      // Destination: speaker
#define fDestJack   8		      // Destination: audio output jack
#define fLoopBack   16		      // Loopback packets for testing
#define fCompGSM    32		      // GSM compression
#define fEncDES     64		      // DES encrypted
#define fEncOTP     128 	      // One-time pad encrypted
#define fEncIDEA    256 	      // IDEA encrypted
#define fCompADPCM	512 		  // ADPCM compressed
#define fEncPGP		1024		  // PGP-protected session key encrypted
#define fKeyPGP		2048		  // Packet contains PGP-encrypted session key

/*	The following flags appear in the compression field of sound
	buffers but never figure in buffers actually transmitted on
	the network; they're used purely for internal housekeeping.
	In some cases flags used in network buffers are reused.  */

#define fFromModem	0x8000		  // From the modem
#define fPlayback	0x80000000	  // Answering machine playback packet
#define fAnsNewMsg	1			  // Start of new message on answering machine

//	Answering machine file format

struct respHeader {
	struct in_addr hostIPnumber;	// IP number of sending host
	time_t itemTime;				// Time and date buffer received
	short hostNameLength;			// Length of hostName including zero terminator
	short soundBufLength;			// Length of sound buffer
	
/*	The following items appear in the file after the header defined
	above, with lengths as given in the header.  */

//	char hostName[hostNameLength];	// Full name of host
//	soundbuf fileSoundBuf;			// Sound buffer, truncated to soundBufLength bytes 
};

//  Some useful types missing from 16-bit Windows

#ifndef WIN32
typedef char CHAR;
typedef int INT;
typedef unsigned long ULONG;
typedef ULONG *PULONG;
typedef ULONG *LPULONG;
#endif

//  Socket-specific types

typedef INT	SOCKERR;        			// A socket error code
typedef WORD PORT;           			// A socket port number
typedef WORD SOCKEVENT;					// An asynchronous socket event

//  Potential states for connection windows

typedef enum _CLIENT_STATE
{
    Embryonic,                          // Newly creates connection
    Idle,                               // Idle
    SendingLiveAudio,                   // Sending live audio
    Transferring,                       // Sending audio file
    PlayingReceivedAudio                // Playing audio received from remote host

} CLIENT_STATE;

/*  Connection window data.  A pointer to this structure is
	kept at offset GWL_CLIENT in each connection window. */

typedef struct _CLIENT_DATA {
    DWORD dwType;                		// Type of window (WINDOW_TYPE_CLIENT)
    CLIENT_STATE state;                 // Current state.
    SOCKET sReply;                		// Socket waiting for reply from srv
    int timeout;               			// Timeout counter
    SOCKADDR_IN inetSock;            	// Client's socket address
    CHAR szHost[MAX_HOST];    			// Target server's host name
    HFILE hFile;                 		// Handle to open file
    DWORD cbSent;                		// Count of bytes sent so far.
    DWORD cbReceived;            		// Count of bytes received so far
    CHAR szFile[MAX_PATH];      		// Name of file being sent
    HANDLE getNameTask;					// Get full site name task handle
    BYTE hostBuffer[MAXGETHOSTSTRUCT];	// Host name reply buffer
    
    int modemConnection;				// Connection is via the modem
    HMMIO mmioHandle;					// WAVE file MMIO handle
    LPWAVEFORMAT mmioFormat;			// WAVE file format descriptor
    DWORD mmioDataLeft;					// WAVE file data left to send
    int quitSoundFile;					// Abort current sound file ?
    int wantsInput;						// Is wave input wanted ?
    int outputSocketBusy;				// Output socket is busy with a sendto()
    struct sockaddr_in name;			// Target system address
    char desKeyString[256];				// DES key string
    char deskey[9];                   	// Destination DES key, if any
    char ideaKeyString[256];			// IDEA key string
    char ideakey[17];                 	// Destination IDEA key, if any
    char pgpkeymd5[16];					// Inbound MD5 signature of PGP session key
    char pgpkey[17];					// Inbound PGP-transmitted session key
    char pgpFileName[MAX_PATH];			// Inbound PGP decoded file name, if strlen > 0
	char opgpUserList[256];				// Outbound PGP user ID list
    char opgpkey[17];					// Outbound PGP-transmitted session key
    char opgpFileName[MAX_PATH];		// Outbound PGP decoded file name, if strlen > 0
    char otpFileName[MAX_PATH];			// One-time pad file name
    char otp[BUFL];                     // One-time pad
    int multicast_scope;				// Multicast scope (time-to-live)
    int squelch;						// Squelch
    int ring;							// Ring
    int debugging;						// Debug mode
    int debugReq;						// Debug output requested by remote ?
    int loopback;						// Loopback mode
    int saveKeys;						// Save keys in connection file
    char connectionFileName[MAX_PATH];	// Connection file name for save
    gsm gsmh;							// GSM handle

} CLIENT_DATA, FAR *LPCLIENT_DATA;

#define CLIENTPTR(w)            ((LPCLIENT_DATA)GetWindowLong((w), GWL_CLIENT))
#define IS_CLIENT_WINDOW(w)     (CLIENTPTR(w)->dwType == WINDOW_TYPE_CLIENT)

//  Socket related data

extern SOCKET sCommand;							// Command socket

//  Various handles

extern HINSTANCE hInst;							// The current instance handle
extern HACCEL hAccel;							// Accelerator table handle
extern HWND hwndMDIFrame;						// MDI frame  window handle
extern HWND hwndMDIClient;						// MDI client window handle
extern HWND hDlgPropeller;						// Propeller head dialogue handle
extern FARPROC pfnPropeller;					// Propeller head procedure instance
extern HWND hDlgAnswer;							// Answering machine dialogue handle
extern FARPROC pfnAnswer;						// Answering machine procedure instance

//  Window class names

extern LPSTR pszFrameClass;						// MDI frame  window class
extern LPSTR pszMDIClientClass;					// MDI client window class
extern LPSTR pszClientClass;					// MDI child window class

//  Miscellaneous data

extern LPSTR pszAppName;						// Application name
extern INT tmAveCharWidth;						// TEXTMETRIC.tmAveCharWidth
extern INT tmHeight;							// TEXTMETRIC.tmHeight
extern LPSTR commandLine;						// Command line from invocation
extern int holped;								// Help was invoked somewhere
extern UINT fileOpenHelpButton;					// File open help button message value
extern char *fileHelpKey;						// Help key for file open/save in progress

extern HWAVEOUT hWaveOut;						// Wave output handle
extern HWAVEIN hWaveIn;                  		// Wave input handle

extern soundbuf ebuf;							// Utility sound buffer

//	Compression modes

extern int compression;							// 2X compression mode
extern int gsmcompress;							// GSM compression mode
extern int adpcmcompress;						// ADPCM compression mode
extern gsm gsmh;								// GSM compression handle
extern int currentInputSamples;					// Samples desired in current input buffers

//	Audio settings for About dialogue

extern int inputActive, outputActive;			// Current activity flags
extern int halfDuplex;                          // Is hardware half-duplex
extern int aboutInSamples;						// Input samples per second
extern int aboutInBits;							// Input bits per sample
extern int aboutOutSamples;						// Output samples per second
extern int aboutOutBits;						// Output bits per sample 

//	Propeller head information

extern long packetsReceived, packetsSent;		// Network packet traffic counters
extern long inputPacketsLost, outputPacketsLost;// Packets lost counters
extern int openConnections;						// Number of open connections
extern int halfDuplexTransition;				// Transitioning from output to input ?
extern int outputInShutdown;					// Close output when last buffer returned
extern long outputPending;						// Output buffers in queue
extern int messageQueueSize;					// Message queue size

//	Network configuration for About dialogue

extern int aboutUDPmax;                         // Longest UDP packet network handles
extern int netMaxSamples;						// Maximum samples, possibly net constrained

//	Windows and driver bug work-around options

extern int alwaysBindSocket;					// Bind output socket to avoid
												// bug in some WINSOCK implementations
extern int useSendNotSendto;					/* Use send() instead of sendto()
												   if buggy (Microsoft) WINSOCK
												   refuses to accept sendto() on
												   a connect()-ed socket. */
extern int waNetNoConnect;						// Don't connect(), use sendto()
extern int waNetUseSend;						// Use send(), not sendto() always
extern int waNetMultiTTLisChar;					// Argument to IP_MULTICAST_TTL setsockopt is char
extern int waAudioHalf;							// Assume audio half-duplex; don't test
extern int waAudio11025;						// Assume audio 11025 samples/sec												

//	Modem configuration information

#define	modemInputQueue	10240
#define modemOutputQueue 10240

extern int modemEnable;							// Modem connections enabled ?
extern char modemInitString[128];				// Modem initialisation string
extern char baudrate[12];						// Baud rate
extern char commport[12];						// Communications port
extern int modemHandle;							// Open modem comm port handle
extern int modemSessions;						// Open sessions on modem
extern int modemShowRant;						// Show rant about Windows serial I/O support

//	Remembered connections

extern int rememberedConnections;				// Number of remembered connections
extern LPSTR rememberedConnection[REMEMBER_CONNECTIONS];  // Remembered connections

//	Multicast settings

extern int multiMemberships;					// Number of multicast group memberships
extern struct in_addr multiAddr[IP_MAX_MEMBERSHIPS]; // Multicast group IP numbers
extern LPSTR multiName[IP_MAX_MEMBERSHIPS];		// Multicast group names
extern int multiLoop;							// Multicast loop-back mode
extern int multiBrainDead;						// Multicast loop-back option not supported

//	Answering machine

extern char answerFileName[MAX_PATH];			// Answering machine file name
extern int answerRecord;						// Record incoming messages

extern HCURSOR phoneCursor, earCursor;			// Cursor handles

extern char blankit[];                          // Long string of blanks

#define V	(void)

#ifdef RANT_ON_ERROR
#define errorRant(hwnd)	{if (modemShowRant) { modemRant(hwnd); } }
#else
#define errorRant(hwnd)
#endif
                                                        
//	Function prototypes

extern void revlong(long FAR *l);
extern void revshort(short FAR *s);                                                        

//	Connection window functions

extern LRESULT CALLBACK connectWndProc(HWND hwnd, UINT nMessage,
								WPARAM wParam, LPARAM lParam);
extern HWND createNewConnection(LPCLIENT_DATA pClientData);

//  Dialogue functions

extern VOID aboutDialogue(HWND hwndParent);
extern VOID propellerHeadDialogue(HWND hwndParent);
extern BOOL CALLBACK propellerHeadDlgProc(HWND hwnd,
							UINT nMessage, WPARAM wParam, LPARAM lParam);
extern void propUpdateAudio(void);							
extern BOOL newHostDialogue(HWND hwndParent, LPSTR pszHostName, LPIN_ADDR paddr);
extern VOID genKeyDialogue(HWND hwnd);
extern VOID connectionProperties(HWND hwnd, LPCLIENT_DATA d);
extern VOID modemSetupDialogue(HWND hwnd);
extern void modemRant(HWND hwnd);
extern VOID multicastGroupsDialogue(HWND hwnd);
extern VOID answerDialogue(HWND hwndParent);
extern BOOL CALLBACK answerDlgProc(HWND hwnd, UINT nMessage,
							WPARAM wParam, LPARAM lParam);

//  Frame window functions

extern LRESULT CALLBACK Frame_WndProc(HWND hwnd, UINT nMessage, WPARAM wParam, LPARAM lParam);

//  Initialisation functions

extern BOOL InitApplication(HINSTANCE hInstance);
extern BOOL InitInstance(HINSTANCE hInstance, LPSTR pszCmdLine, INT nCmdShow);

//	WAVE file I/O functions

extern int readWaveInit(HWND hwndApp, LPCLIENT_DATA d, LPSTR szFileName);
extern int readWaveNext(HWND hwnd, LPCLIENT_DATA d);
extern void readWaveTerm(LPCLIENT_DATA d);

//	CRC calculator functions

extern unsigned short crc(unsigned char __far *buff, int bufflen);

//	Modem driver functions

extern int openModem(HWND hwnd);
extern int closeModem(HWND hwnd);

//	Answering machine functions

extern int answerOpen(void);
extern void answerSave(struct in_addr IPaddr, LPSTR hostName, soundbuf *sb);
extern void answerSync(void);
extern void answerClose(void);
extern int answerEnabled(void);        

//  Utility functions

extern char *rstring(int resid);
extern char *rfilter(int resid);
extern INT MsgBox(HWND hwndParent, UINT fuType, LPSTR pszFormat, ...);
extern VOID WinPrintf(HDC hdc, INT row, INT col, LPSTR pszFormat, ...);
extern LPSTR SockerrToString(SOCKERR serr);
extern SOCKERR ResetSocket(SOCKET sock);
extern SOCKERR CreateSocket(SOCKET FAR * psock, INT type, ULONG address, PORT port);
extern void playSound(HWND hWnd, LPCLIENT_DATA pClientData, soundbuf *d,
					  int bitsPerSample, int samplesPerSecond);
extern int startWaveInput(HWND hwnd);
extern int inputSampleCount(void);
extern void terminateWaveInput(void);
extern void compress2X(soundbuf *asb);
extern void createSoundBuffer(LPSTR buffer, WORD buflen, DWORD channels,
							  DWORD rate, DWORD bytesec, WORD align);
extern void shipSoundBuffer(HWND hwnd, LPCLIENT_DATA pClientData);							  
extern VOID startSoundFile(HWND hwnd, LPSTR pszFile);
extern int makeInternalEncryptionKeys(HWND hwnd, LPCLIENT_DATA d);
extern void multicastJoin(HWND hwnd, int join);
extern void propeller(int control, DWORD value);
extern int obtainOutput(HWND hwnd);




