/*

		     RTP output packet generation

*/

#include "speakfree.h"
#include <pwd.h>
#include <sys/param.h>

/*  RTP_MAKE_SDES  --  Generate a source description for this
		       user, based either on information obtained
		       from the password file or supplied by
		       environment variables.  */

int rtp_make_sdes(pkt, ssrc_i, port)
  char **pkt;
  unsigned long ssrc_i;
  int port;
{
    char p[1500];
    rtcp_t *rp = (rtcp_t *) p;
    char *ap, *sp, *ep;
    int l;
    struct passwd *pw;
    char s[256], ev[1024];

#define addSDES(item, text) *ap++ = item; *ap++ = l = strlen(text); \
			    bcopy(text, ap, l); ap += l

    rp->common.version = RTP_VERSION;
    rp->common.p = 0;
    rp->common.count = 1;
    rp->common.pt = RTCP_SDES;
    rp->r.sdes.src = ssrc_i;

    ap = (char *) rp->r.sdes.item;

    ep = getenv("SPEAKFREE_ID");
    if (ep != NULL) {
	if (strlen(ep) == 0) {
	    ep = NULL;
	} else {
	    strcpy(ev, ep);
	    ep = ev;
	}
    }

    /* Build canonical name for this user.  This is generally
       a name which can be used for "talk" and "finger", and
       is not necessarily the user's E-mail address. */

    if ((sp = getenv("SPEAKFREE_CNAME")) != NULL && strlen(sp) > 0) {
	addSDES(RTCP_SDES_CNAME, sp);
    } else {
	pw = getpwuid(getuid());
	if (pw != NULL) {
	    char dn[64];
	    char hn[MAXHOSTNAMELEN];

	    dn[0] = hn[0] = 0;
	    getdomainname(dn, sizeof dn);
	    gethostname(hn, sizeof hn);
	    if (dn[0] != 0) {
                sprintf(s, "%s@%s", pw->pw_name, dn);
	    } else {
		struct hostent *h;
		struct in_addr naddr;

		h = gethostbyname(hn);
		bcopy(h->h_addr, &naddr, sizeof naddr);
                sprintf(s, "%s@%s", pw->pw_name, inet_ntoa(naddr));
	    }
	    addSDES(RTCP_SDES_CNAME, s);
	    if (ep == NULL && pw->pw_gecos != NULL) {
                char *gc = strchr(pw->pw_gecos, ',');

		if (gc != NULL) {
		    *gc = 0;
		}
		addSDES(RTCP_SDES_NAME, pw->pw_gecos);
	    }
	} else {
#ifdef Solaris
	    {	char s[12];
		sysinfo(SI_HW_SERIAL, s, 12);
                sprintf(s, "Unknown@%s.hostid.net", s);
	    }
#else
            sprintf(s, "Unknown@%lu.hostid.net", gethostid());
#endif
	    addSDES(RTCP_SDES_CNAME, s);
	}
    }

    /* If a SPEAKFREE_ID environment variable is present,
       parse the items it contains.  Format:

       SPEAKFREE_ID=<full name>:<E-mail address>:<phone number>:<location>

    */

    if (ep != NULL) {
	int i;
	static int items[] = { RTCP_SDES_NAME, RTCP_SDES_EMAIL,
			       RTCP_SDES_PHONE, RTCP_SDES_LOC };
	char *np;

	for (i = 0; i < ELEMENTS(items); i++) {
	    while (*ep && isspace(*ep)) {
		ep++;
	    }
	    if (*ep == 0) {
		break;
	    }
            if ((np = strchr(ep, ':')) != NULL) {
		*np++ = 0;
	    } else {
		np = NULL;
	    }
	    if (strlen(ep) > 0) {
		addSDES(items[i], ep);
	    }
	    if (np == NULL) {
		break;
	    }
	    ep = np;
	}
    }

    addSDES(RTCP_SDES_TOOL, "Speak Freely for Unix");

    /* If a port number is specified, add a PRIV item indicating
       the port we're communicating on. */

    if (port >= 0) {
	char s[20];

        sprintf(s, "\001P%d", port);
	addSDES(RTCP_SDES_PRIV, s);
    }

    *ap++ = RTCP_SDES_END;
    *ap++ = 0;

    l = ap - p;

    rp->common.length = ((l + 3) / 4) - 1;
    l = (rp->common.length + 1) * 4;
    *pkt = (char *) malloc(l);
    bcopy(p, *pkt, l);
    return l;
}

/*  RTP_MAKE_BYE  --  Create a "BYE" RTCP packet for this connection.  */

int rtp_make_bye(p, ssrc_i, raison)
  char *p;
  unsigned long ssrc_i;
  char *raison;
{
    rtcp_t *rp = (rtcp_t *) p;
    char *ap;
    int l;

    rp->common.version = RTP_VERSION;
    rp->common.p = 0;
    rp->common.count = 1;
    rp->common.pt = RTCP_BYE;
    rp->r.bye.src[0] = ssrc_i;

    ap = (char *) rp->r.sdes.item;

    l = 0;
    if (raison != NULL) {
	l = strlen(raison);
	if (l > 0) {
	    *ap++ = l;
	    bcopy(raison, ap, l);
	    ap += l;
	}
    }

    while ((ap - p) & 3) {
	*ap++ = 0;
    }
    l = ap - p;

    rp->common.length = (l / 4) - 1;
    return (rp->common.length + 1) * 4;
}

#ifdef RTP_SUPPORT

/*

    Warning!  This release of Speak Freely *does not* contain
	      complete support for RTP.  The following is code
	      under-development which will be enabled in a
	      future RTP-compliant version of Speak Freely.

	      The SDES and BYE packet code above is enabled
	      since the Look Who_s Listening facility uses
	      those RTP packets to communicate with the server.
*/

/*  RTPOUT  --	Convert a sound buffer into an RTP packet, given the
		SSRC, timestamp, and sequence number appropriate for the
		next packet sent to this connection.  */

int rtpout(sb, ssrc_i, timestamp_i, seq_i)
  soundbuf *sb;
  unsigned long ssrc_i, timestamp_i;
  unsigned short seq_i;
{
    soundbuf rp;
    rtp_hdr_t *rh = (rtp_hdr_t *) &rp;
    int pl = 0;

    rh->version = RTP_VERSION;
    rh->p = 0;
    rh->x = 0;
    rh->cc = 0;
    rh->m = 0;
    rh->seq = seq_i;
    rh->ts = timestamp_i;
    rh->ssrc = ssrc_i;

    if (sb->compression & fCompGSM) {
	rh->pt = 3;
	bcopy(sb->buffer.buffer_val + 2, ((char *) &rp) + 12,
		  (int) sb->buffer.buffer_len - 2);
	pl = (sb->buffer.buffer_len - 2) + 12;

    } else if (sb->compression & fCompADPCM) {
	rh->pt = 5;
	bcopy(sb->buffer.buffer_val, ((char *) &rp) + 12 + 4,
		  (int) sb->buffer.buffer_len - 3);
	bcopy(sb->buffer.buffer_val + ((int) sb->buffer.buffer_len - 3),
		  ((char *) &rp) + 12, 3);
	((char *) &rp)[15] = 0;
	pl = (sb->buffer.buffer_len - 1) + 12;

    } else {	/* Uncompressed PCMU samples */
	rh->pt = 0;
	bcopy(sb->buffer.buffer_val, ((char *) &rp) + 12,
		(int) sb->buffer.buffer_len);
	pl = (int) sb->buffer.buffer_len + 12;
    }
    if (pl > 0) {
	bcopy((char *) &rp, (char *) sb, pl);
    }
    return pl;
}
#endif
