/*

		       RTP input packet parsing

*/

#include "speakfree.h"

#ifdef RTP_SUPPORT
/*
    Warning!  This release of Speak Freely *does not* contain
	      complete support for RTP.  The following is code
	      under-development which will be enabled in a
	      future RTP-compliant version of Speak Freely.
*/

audio_descr_t adt[] = {
/* enc	   sample ch */
  {AE_PCMU,  8000, 1},	/*  0 PCMU */
  {AE_MAX,   8000, 1},	/*  1 1016 */
  {AE_G721,  8000, 1},	/*  2 G721 */
  {AE_GSM,   8000, 1},	/*  3 GSM */
  {AE_G723,  8000, 1},	/*  4 Unassigned */
  {AE_IDVI,  8000, 1},	/*  5 DVI4 */
  {AE_IDVI, 16000, 1},	/*  6 DVI4 */
  {AE_LPC,   8000, 1},	/*  7 LPC */
  {AE_MAX,	0, 1},	/*  8 PCMA */
  {AE_MAX,	0, 1},	/*  9 G722 */
  {AE_L16,  44100, 2},	/* 10 L16 */
  {AE_L16,  44100, 1},	/* 11 L16 */
  {AE_MAX,	0, 1},	/* 12 */
};

#define MAX_MISORDER 100
#define MAX_DROPOUT  3000

int isrtp(pkt, len, c)
  unsigned char *pkt;
  int len;
  struct connection *c;
{
    rtp_hdr_t *rh = (rtp_hdr_t *) pkt;

/*fprintf(stderr, "Ver = %d, pt = %d, p = %d, x = %d\n",
rh->version, rh->pt, rh->p, rh->x); */

    if (rh->version == RTP_VERSION && /* Version ID correct */
	rh->pt < ELEMENTS(adt) &&     /* Payload type credible */
	adt[rh->pt].sample_rate != 0 && /* Defined payload type */
				      /* Padding, if present, is plausible */
	(!rh->p || (pkt[len - 1] < (len - (12 + 4 * rh->cc)))) &&
	!rh->x			      /* No extension present */
       ) {
	struct soundbuf sb;
	unsigned char *payload;
	int paylen;

	payload = pkt + (12 + 4 * rh->cc); /* Start of payload */
	paylen = len - ((12 + 4 * rh->cc) +/* Length of payload */
		    (rh->p ? pkt[len - 1] : 0));
	sb.compression = 0;
	sb.buffer.buffer_len = 0;

	/* Fake an RTP unique host name from the SSRC identifier. */

        sprintf(sb.sendinghost, ".RTP:%02X%02X%02X%02X",
	    pkt[8], pkt[9], pkt[10], pkt[11]);

	switch (adt[rh->pt].encoding) {

	    case AE_PCMU:
		sb.buffer.buffer_len = paylen;
		bcopy(payload, sb.buffer.buffer_val, paylen);
		break;

	    case AE_GSM:
		sb.buffer.buffer_len = paylen + sizeof(short);
		bcopy(payload, sb.buffer.buffer_val + 2, paylen);
		*((short *) sb.buffer.buffer_val) =
		    (paylen * 160) / 33;
		sb.compression |= fCompGSM;
		break;

	    case AE_IDVI:
		bcopy(payload + 4, sb.buffer.buffer_val, paylen - 4);
		sb.buffer.buffer_len = paylen - 1;
		bcopy(payload, sb.buffer.buffer_val + (paylen - 4), 3);
		sb.buffer.buffer_len = paylen - 1;
		if (adt[rh->pt].sample_rate == 8000) {
		    sb.compression |= fCompADPCM;
		} else {

		    /* Bogus attempt to convert sampling rate.	We
                       really need to do this in linear mode, which isn't
		       supported on all SPARCs.  This is better than
		       nothing, though. */

		    int inc = adt[rh->pt].sample_rate / 8000, i;
		    unsigned char *in = (unsigned char *) sb.buffer.buffer_val,
				  *out = (unsigned char *) sb.buffer.buffer_val;

		    adpcmdecomp(&sb);
		    for (i = 0; i < (paylen - 4) / inc; i++) {
			*out++ = *in;
			in += inc;
		    }
		    sb.buffer.buffer_len /= inc;
		}
		break;

	    case AE_LPC:
		{
		    lpc_synthesize((lpcparams_t *) payload, 1.0,
			(unsigned char *) sb.buffer.buffer_val);
		    sb.buffer.buffer_len = 160;
		}
		break;

	    case AE_L16:
		if (adt[rh->pt].channels == 1) {
		    int i, j, k;
		
		    for (i = j = k = 0; i < (paylen / 8); i++) {
			if ((k & 3) != 2  && ((i % 580) != 579)) {
			    sb.buffer.buffer_val[j++] =
				audio_s2u((((unsigned short *) payload)[i * 4]));
			}
			k = (k + 1) % 11;
		    }
		    sb.buffer.buffer_len = j;
		} else if (adt[rh->pt].channels == 2) {
		    int i, j, k;
		
		    for (i = j = k = 0; i < (paylen / 16); i++) {
			if ((k & 3) != 2  && ((i % 580) != 579)) {
			    sb.buffer.buffer_val[j++] =
				audio_s2u(((((unsigned short *) payload)[i * 8]) +
					   (((unsigned short *) payload)[i * 8 + 1])) / 2);
			}
			k = (k + 1) % 11;
		    }
		    sb.buffer.buffer_len = j;
		}
		break;

	    default:
		/* Unknown compression type. */
		break;
	}
	bcopy(&sb, pkt, ((sizeof sb - BUFL)) + sb.buffer.buffer_len);
	return TRUE;
    }
    return FALSE;
}
#endif
