/*

    Emulation of BSD usleep() for Solaris 2.x

    Contributed by Hans Werner Strube (strube@physik3.gwdg.de).

*/

#ifdef Solaris

#include <sys/time.h>
#include <sys/signal.h>

volatile static int waiting;

static void getalrm(i)
  int i;
{
    waiting = 0;
}

void usleep(t)
  unsigned t;
{   static struct itimerval it;

    it.it_value.tv_sec = t / 1000000;
    it.it_value.tv_usec = t % 1000000;
    signal(SIGALRM, getalrm);
    waiting = 1;
    if (setitimer(ITIMER_REAL, &it, 0))
	return /*error*/;
    while (waiting)
	pause();
}
#endif
